% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-structures.R
\name{notebook_task}
\alias{notebook_task}
\title{Notebook Task}
\usage{
notebook_task(notebook_path, base_parameters = list())
}
\arguments{
\item{notebook_path}{The absolute path of the notebook to be run in the
Databricks workspace. This path must begin with a slash.}

\item{base_parameters}{Named list of base parameters to be used for each run
of this job.}
}
\description{
Notebook Task
}
\details{
If the run is initiated by a call to \code{\link[=db_jobs_run_now]{db_jobs_run_now()}} with parameters
specified, the two parameters maps are merged. If the same key is specified
in base_parameters and in run-now, the value from run-now is used.

Use Task parameter variables to set parameters containing information about
job runs.

If the notebook takes a parameter that is not specified in the job’s
\code{base_parameters} or the run-now override parameters, the default value from
the notebook is used.

Retrieve these parameters in a notebook using \code{dbutils.widgets.get}.
}
\seealso{
Other Task Objects: 
\code{\link{email_notifications}()},
\code{\link{libraries}()},
\code{\link{new_cluster}()},
\code{\link{pipeline_task}()},
\code{\link{python_wheel_task}()},
\code{\link{spark_jar_task}()},
\code{\link{spark_python_task}()},
\code{\link{spark_submit_task}()}
}
\concept{Task Objects}
