% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bricks-from-tables.R
\name{bricks_from_coords}
\alias{bricks_from_coords}
\title{Create a 3D model object from a long coordinate data frame}
\usage{
bricks_from_coords(
  coord_table,
  use_bricks = NULL,
  increment_level = 0,
  min_level = 1,
  max_level = Inf,
  increment_x = 0,
  max_x = Inf,
  increment_y = 0,
  max_y = Inf,
  exclude_color = NULL,
  exclude_level = NULL
)
}
\arguments{
\item{coord_table}{A data frame of a 3D brick model design. Contains 'x', 'y', and 'z' (vertical height) dimensions, as well as 'Color' from official LEGO color names.
See \code{\link{build_colors}}. Optional column 'piece_type' for shapes other than rectangular bricks.
Optional column ' mid_Level' with values 0, 1, or 2 (default 0) for 1-height placement of bricks.}

\item{use_bricks}{Array of brick sizes to use in mosaic. Defaults to \code{c('4x2', '3x2', '2x2', '3x1', '2x1', '1x1')}`.}

\item{increment_level}{Default '0'. Use in animations. Shift  Level/z dimension by an integer.}

\item{min_level}{Default '1'. Use in animations. Any Level/z values below this value will be cut off.}

\item{max_level}{Default 'Inf'. Use in animations. Any Level/z values above this value will be cut off.}

\item{increment_x}{Default '0'. Use in animations. Shift x dimension by an integer.}

\item{max_x}{Default 'Inf'. Use in animations. Any x values above this value will be cut off.}

\item{increment_y}{Default '0'. Use in animations. Shift y dimension by an integer.}

\item{max_y}{Default 'Inf'. Use in animations. Any y values above this value will be cut off.}

\item{exclude_color}{Numeric array of color ID numbers to exclude.}

\item{exclude_level}{Numeric array of Level/z dimensions to exclude.}
}
\value{
A list with elements \code{Img_lego} to pass to \code{\link{build_bricks}}.
}
\description{
Convert a data frame with x, y, z & Color columns into a 3D object
}
\examples{
#This is a 1x4 yellow brick
brick <- data.frame(
        x = 1:4,
        y = 1, z=1,
        color = "Bright yellow", 
        stringsAsFactors=FALSE)

brick \%>\% 
  bricks_from_coords() \%>\% 
  build_bricks()
  
  rgl::clear3d()
  
#This is a lot of bricks
bricks <- expand.grid(
x = 1:4,
y = 1:2,
z = 1:3)

#Color them in sets of these 3 options
bricks$color <- rep(rep(c("Bright yellow", "Bright red", "Tr. green"), each=4), 2)

\donttest{
bricks \%>\% 
  bricks_from_coords() \%>\% 
  build_bricks()
  
  rgl::clear3d()
  }
  
#Use different brick shapes by added a 'piece_type' column
bricks$piece_type <- "c1" #Make all the pieces cylinders

\donttest{
bricks \%>\% 
  bricks_from_coords() \%>\% 
  build_bricks()
  
  rgl::clear3d()
  }

}
\seealso{
Other 3D Models: 
\code{\link{bricks_from_excel}()},
\code{\link{bricks_from_mosaic}()},
\code{\link{bricks_from_table}()},
\code{\link{build_bricks}()}
}
\concept{3D Models}
