% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_betta.R
\name{betta_pic}
\alias{betta_pic}
\title{function for plotting total diversity}
\usage{
betta_pic(
  y,
  se,
  x = 1:length(y),
  ylimu = NULL,
  myy = NULL,
  mymain = NULL,
  mycol = NULL,
  labs = NULL,
  mypch = NULL,
  myxlim = NULL
)
}
\arguments{
\item{y}{A vector of estimates of total diversity. Other parameter estimates
are accessible; this method may be used for plotting any parameter
estimates..}

\item{se}{The standard errors in \samp{y}, the diversity (or other
parameter's) estimates.}

\item{x}{A vector of covariates to form the x-coordinates of the intervals.
If no argument is given, defaults to the order.}

\item{ylimu}{The upper endpoint of the y-axis.}

\item{myy}{Deprecated, for backwards compatibility}

\item{mymain}{Deprecated, for backwards compatibility}

\item{mycol}{Deprecated, for backwards compatibility}

\item{labs}{Deprecated, for backwards compatibility}

\item{mypch}{Deprecated, for backwards compatibility}

\item{myxlim}{Deprecated, for backwards compatibility}
}
\value{
A ggplot object.
}
\description{
A simple plotting interface for comparing total diversity across samples or
a covariate gradient.
}
\examples{
betta_pic(c(1552, 1500, 884), c(305, 675, 205), mymain = "Example title")

}
\references{
Willis, A., Bunge, J., and Whitman, T. (2015). Inference for
changes in biodiversity. arXiv preprint.
}
\seealso{
\code{\link{betta}}
}
\author{
Amy Willis
}
\keyword{diversity}
