% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_betta_random.R
\name{betta_random}
\alias{betta_random}
\title{modelling total diversity with random effects}
\usage{
betta_random(
  chats = NULL,
  ses,
  X = NULL,
  groups = NULL,
  formula = NULL,
  data = NULL,
  n_initializations = 10
)
}
\arguments{
\item{chats}{A vector of estimates of total diversity at different sampling
locations. Required with the \code{groups} argument, and optionally with the
\code{X} argument.}

\item{ses}{The standard errors in \code{chats}, the diversity estimates. This
can either be a vector of standard errors (with the arguments \code{chats} and
\code{X}), or the name of the variable in the dataframe \code{data} that contains
the standard errors (with the arguments \code{formula} and \code{data}).}

\item{X}{A numeric matrix of covariates corresponding to fixed effects. If
not supplied, an intercept-only model will be fit. Optional with the \code{chats}
and \code{groups} arguments.}

\item{groups}{A categorical variable representing the random-effects groups
that each of the estimates belong to. Required with the \code{chats} argument and
optionally with the \code{X} argument.}

\item{formula}{A formula object of the form \eqn{y ~ x | group}. Required with
the \code{data} argument.}

\item{data}{A dataframe containing the response, response standard errors, covariates,
and grouping variable. Required with the \code{formula} argument.}

\item{n_initializations}{A positive integer giving number of random
initializations to be used in optimization (default 10)}
}
\value{
\item{table}{ A coefficient table for the model parameters. The
columns give the parameter estimates, standard errors, and p-values,
respectively. This model is only as effective as your diversity estimation
procedure; for this reason please confirm that your estimates are
appropriate and that your model is not misspecified. betta_pic may be
useful for this purpose.  } \item{cov}{ Estimated covariance matrix of the
parameter estimates.  } \item{ssq_u}{ The estimate of the heterogeneity
variance.  } \item{ssq_g}{ Estimates of within-group variance. The estimate
will be zero for groups with only one observation.  } \item{homogeneity}{
The test statistic and p-value for the test of homogeneity.  }
\item{global}{ The test statistic and p-value for the test of model
explanatory power.  } \item{blups}{ The conditional expected values of the
diversity estimates (conditional on the random effects). Estimates of
variability for the random effects case are unavailable at this time; please
contact the maintainer if needed.} \item{function.args}{A list containing
values initially passed to betta_random.}
}
\description{
This function extends betta() to permit random effects modelling.
}
\examples{

df <- data.frame(chats = c(2000, 3000, 4000, 3000),
ses = c(100, 200, 150, 180),
Cont_var = c(100, 150, 100, 50),
groups = c("a", "a", "a", "b"))

# formula notation
betta_random(formula = chats ~ Cont_var| groups,
ses = ses,
 data = df)

# direct input
betta_random(c(2000, 3000, 4000, 3000), c(100, 200, 150, 180),
X = cbind(Int = 1, Cont_var = c(100, 150, 100, 50)),
groups = c("a", "a", "a", "b"))

## handles missing data
betta_random(c(2000, 3000, 4000, 3000), c(100, 200, 150, NA),
groups = c("a", NA,
    "b", "b"))

}
\references{
Willis, A., Bunge, J., and Whitman, T. (2015). Inference for
changes in biodiversity. \emph{arXiv preprint.}
}
\seealso{
\code{\link{betta}};
}
\author{
Amy Willis
}
\keyword{diversity}
