% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write4D.file.R
\name{write4D.file}
\alias{write4D.file}
\title{Write a 4D scene}
\usage{
write4D.file(
  scene = NULL,
  outfile = "index_4D.html",
  fnames,
  visible = TRUE,
  opacity = 1,
  colors = NULL,
  captions = "",
  standalone = FALSE,
  rescale = FALSE,
  index.file = system.file("index_template.html", package = "brainR"),
  toggle = "checkbox",
  xtkgui = FALSE
)
}
\arguments{
\item{scene}{- list of 3D triangles (see \link[misc3d]{contour3d}).  If a multicolored
object is to be rendered (multiple contours with one control) - it must be in a 
list}

\item{outfile}{- html filename that is to be exported}

\item{fnames}{- filenames for the 3D surfaces in the scene - needs to 
be the same length as scene}

\item{visible}{- logical vector indicating which structures are visible in 
html file}

\item{opacity}{- list of alpha values - same length as scene; if sub-structures
are present, then the each list element has length the number of structures}

\item{colors}{- character vector of colors (col2rgb is applied)}

\item{captions}{- labels for checkboxes on html webpage}

\item{standalone}{- logical - should this be able to be rendered offline?}

\item{rescale}{- rescale the scene? - in beta}

\item{index.file}{- template html file used}

\item{toggle}{- (experimental) "checkbox" (default) or "radio" for radio or checkboxes to switch thing}

\item{xtkgui}{- (experimental) Logical to use xtkgui for objects}
}
\description{
This function takes in a scene and writes it out to a series of files
either with the stl format or obj format
}
\examples{

template <- readNIfTI(system.file("MNI152_T1_8mm_brain.nii.gz", package="brainR")
, reorient=FALSE)
dtemp <- dim(template)
### 4500 - value that empirically value that presented a brain with gyri
### lower values result in a smoother surface
brain <- contour3d(template, x=1:dtemp[1], y=1:dtemp[2],
z=1:dtemp[3], level = 4500, alpha = 0.8, draw = FALSE)

### Example data courtesy of Daniel Reich
### Each visit is a binary mask of lesions in the brain
imgs <- paste("Visit_", 1:5, "_8mm.nii.gz", sep="")
files <- sapply(imgs, system.file, package='brainR')
scene <- list(brain)
## loop through images and thresh
nimgs <- length(imgs)
cols <- rainbow(nimgs)
for (iimg in 1:nimgs) {
mask <- readNIfTI(files[iimg], reorient=FALSE)
if (length(dim(mask)) > 3) mask <- mask[,,,1]
### use 0.99 for level of mask - binary
  activation <- contour3d(mask, level = c(0.99), alpha = 1,
  add = TRUE, color=cols[iimg], draw=FALSE)
## add these triangles to the list
scene <- c(scene, list(activation))
}
## make output image names from image names
fnames <- c("brain.stl", gsub(".nii.gz", ".stl", imgs, fixed=TRUE))
fnames = file.path(tempdir(), fnames)
outfile <-  file.path(tempdir(), "index.html")
write4D.file(
scene=scene, fnames=fnames, 
visible = FALSE,
outfile=outfile, standalone=TRUE, rescale=TRUE)



unlink(outfile)
unlink(fnames)
}
\seealso{
\code{\link{writeOBJ}}, \code{\link{writeSTL}}, 
\code{\link{contour3d}}
}
