% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brainGraph_GLM.R
\name{GLM}
\alias{GLM}
\alias{brainGraph_GLM}
\alias{summary.bg_GLM}
\alias{plot.bg_GLM}
\title{Fit linear models at each vertex of a graph}
\usage{
brainGraph_GLM(g.list, covars, measure, con.mat, con.type = c("t", "f"),
  X = NULL, con.name = NULL, alternative = c("two.sided", "less",
  "greater"), alpha = 0.05, level = c("vertex", "graph"),
  permute = FALSE, N = 5000, perms = NULL, long = FALSE, ...)

\method{summary}{bg_GLM}(object, p.sig = c("p", "p.fdr", "p.perm"),
  contrast = NULL, digits = max(3L, getOption("digits") - 2L),
  print.head = TRUE, ...)

\method{plot}{bg_GLM}(x, region = NULL, which = c(1L:3L, 5L), ...)
}
\arguments{
\item{g.list}{A list of \code{igraph} graph objects for all subjects}

\item{covars}{A \code{data.table} of covariates}

\item{measure}{Character string of the graph measure of interest}

\item{con.mat}{Numeric matrix specifying the contrast(s) of interest; if
only one contrast is desired, you can supply a vector}

\item{con.type}{Character string; either \code{'t'} or \code{'f'} (for t or
F-statistics). Default: \code{'t'}}

\item{X}{Numeric matrix, if you wish to supply your own design matrix
(default: \code{NULL})}

\item{con.name}{Character vector of the contrast name(s); if \code{con.mat}
has row names, those will be used for reporting results (default:
\code{NULL})}

\item{alternative}{Character string, whether to do a two- or one-sided test
(default: \code{'two.sided'})}

\item{alpha}{Numeric; the significance level (default: 0.05)}

\item{level}{Character string; either \code{vertex} (default) or
\code{graph}}

\item{permute}{Logical indicating whether or not to permute group labels
(default: \code{FALSE})}

\item{N}{Integer; number of permutations to create (default: 5e3)}

\item{perms}{Matrix of permutations, if you would like to provide your own
(default: \code{NULL})}

\item{long}{Logical indicating whether or not to return all permutation
results (default: \code{FALSE})}

\item{...}{Other arguments passed to \code{\link{brainGraph_GLM_design}}}

\item{object}{A \code{bg_GLM} object}

\item{p.sig}{Character string specifying which p-value to use for displaying
significant results (default: \code{p})}

\item{contrast}{Integer specifying the contrast to plot/summarize; defaults
to showing results for all contrasts}

\item{digits}{Integer specifying the number of digits to display for p-values}

\item{print.head}{Logical indicating whether or not to print only the first
and last 5 rows of the statistics tables (default: \code{TRUE})}

\item{x}{A \code{bg_GLM} object}

\item{region}{Character string specifying which region's results to
plot; only relevant if \code{level='vertex'} (default: \code{NULL})}

\item{which}{Integer vector indicating which of the 6 plots to print to the
plot device (default: \code{c(1:3, 5)})}
}
\value{
An object of class \code{bg_GLM} containing some input-specific
  variables, in addition to:
  \item{X}{A numeric matrix; a copy of the \emph{design matrix}}
  \item{y}{A numeric vector or matrix of the outcome variable}
  \item{DT}{A data table with an entry for each vertex (region) containing
    statistics of interest}
  \item{removed}{A character vector of Study.ID's removed due to incomplete
    data (if any)}
  \item{perm}{A list containing: \emph{null.dist} (the null distribution of
    maximum statistics), \emph{thresh} (the statistic value corresponding
    to the \eqn{100 \times (1 - \alpha)}th\% percentile of the null
    distribution)}

The \code{plot} method returns a \emph{list} of
  \code{\link[ggplot2]{ggplot}} objects
}
\description{
\code{brainGraph_GLM} specifies and fits a linear model at each vertex for a
given vertex measure (e.g. \emph{degree}) or at the graph-level (e.g.,
\emph{global efficiency}). Given a contrast matrix, it will calculate the
associated statistics.

The \code{summary} method prints the results, only for which
\eqn{p < \alpha}; you may change this to the FDR-adjusted or permutation
p-values via the function argument \code{p.sig}.

The \code{plot} method plots the GLM diagnostics (similar to that of
\code{\link[stats]{plot.lm}}). There are a total of 6 possible plots,
specified by the \code{which} argument; the behavior is the same as in
\code{\link[stats]{plot.lm}}. Please see the help for that function.
}
\details{
The input list of graphs \code{g.list} must not be nested; i.e., if you have
multiple groups, they will have to be combined into one list. See the code in
the Examples below.

A \code{data.table} of covariates is required input; the first column
\emph{must} be named \emph{Study.ID}. Additionally, all graphs must
have a \emph{name} attribute (at the graph level) which matches the
\emph{Study.ID} for a given subject. If you create the design matrix
\code{X} yourself, you still must supply the covariates table so that
subjects can be correctly matched with their network data.

Both t- and F-contrasts are allowed. You may supply a \emph{matrix} to the
argument \code{con.mat}. If you supply a multi-row matrix and you choose
\code{con.type="t"}, then statistics will be calculated for each contrast
individually. If you choose \code{con.type="f"}, in the result data table,
\code{ESS} stands for "extra sum of squares", the additional variance
explained for by the model parameters of interest (as determined by the
contrast matrix). Finally, the standard error in these tables is the sum of
squared errors of the \emph{full model}.

Finally, you can calculate permutations of the data to build a null
distribution of the maximum statistic, to provide control over false
positives. The permutation strategy is that of Freedman & Lane (1983), and
is the same as that in FSL's \emph{randomise}.
}
\examples{
\dontrun{
conmat <- matrix(c(0, 0, 0, 1), nrow=1)
rownames(conmat) <- 'Control > Patient'

## Note that I concatenate the graphs from each group's 6th threshold
g.lm <- brainGraph_GLM(g.list=do.call(Map, c(c, g))[[6]],
  covars=covars.all[tract == 1],
  measure='strength', con.mat=conmat, alt='greater',
  permute=TRUE, long=TRUE)
}
\dontrun{
## Save objects and then to multipage PDF
lmPlots <- plot(x)
ggsave('lmPlots.pdf', lmPlots)

## Save all the GLM sub-objects from MTPC analysis
res.mtpc <- mtpc(...)
glmPlots <- lapply(res.mtpc$res.glm, plot, which=1:6)
ml <- marrangeGrob(glmPlots, nrow=1, ncol=1)
ggsave('glmPlots.pdf', ml, width=8.5, height=11)
}
}
\references{
Freedman D & Lane D (1983). \emph{A nonstochastic interpretation
  of reported significance levels}. J Bus Econ Stat, 1(4):292-298.

Nichols TE & Holmes AP (2001). \emph{Nonparametric permutation
  tests for functional neuroimaging: A primer with examples.} Human Brain
  Mapping, 15(1):1-25.

Winkler AM, Ridgway GR, Webster MA, Smith SM, Nichols TE (2014).
  \emph{Permutation inference for the general linear model}. NeuroImage,
  92:381-397.
}
\seealso{
\code{\link[stats]{plot.lm}}

Other GLM functions: \code{\link{GLMdesign}},
  \code{\link{GLMfit}}, \code{\link{mtpc}}

Other Group analysis functions: \code{\link{Bootstrapping}},
  \code{\link{IndividualContributions}},
  \code{\link{MediationAnalysis}}, \code{\link{NBS}},
  \code{\link{brainGraph_permute}}, \code{\link{mtpc}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\concept{GLM functions}
\concept{Group analysis functions}
