% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_rich_norm.R
\name{plot_rich_norm}
\alias{plot_rich_norm}
\title{Plot normalized rich club coefficients against degree threshold}
\usage{
plot_rich_norm(rich.dt, densities, alpha = 0.05, g = NULL)
}
\arguments{
\item{rich.dt}{A \code{data.table} with rich-club coefficients}

\item{densities}{A numeric vector of the densities to plot}

\item{alpha}{The significance level (DEFAULT: 0.05)}

\item{g}{A list (of lists) of \code{igraph} graph objects; required if you
want to plot a shaded region demarcating the \code{\link{rich.core}}}
}
\value{
A \code{\link[ggplot2]{ggplot}} object
}
\description{
Returns a \code{\link[ggplot2]{ggplot}} object of a line plot of the normalized rich club
coefficient for up to two subject groups. Optionally will include a shaded
region demarcating the \code{\link{rich.core}} cutoff.
}
\examples{
\dontrun{
richPlot <- plot_rich_norm(rich.dt, densities[N:(N+1)], g=g)
}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}

