% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_braid.R
\name{geom_braid_smooth}
\alias{geom_braid_smooth}
\alias{stat_braid_smooth}
\title{Smoothed BRAID Surfaces}
\usage{
geom_braid_smooth(
  mapping = NULL,
  data = NULL,
  stat = "braid_smooth",
  position = "identity",
  ...,
  space = 1.5,
  trim = TRUE,
  shared = FALSE,
  npoints = 50,
  tight = FALSE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_braid_smooth(
  mapping = NULL,
  data = NULL,
  geom = "tile",
  position = "identity",
  ...,
  space = 1.5,
  trim = TRUE,
  shared = FALSE,
  npoints = 50,
  tight = FALSE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this layer.
When using a \verb{geom_*()} function to construct a layer, the \code{stat}
argument can be used the override the default coupling between geoms and
stats. The \code{stat} argument accepts the following:
\itemize{
\item A \code{Stat} ggproto subclass, for example \code{StatCount}.
\item A string naming the stat. To give the stat as a string, strip the
function name of the \code{stat_} prefix. For example, to use \code{stat_count()},
give the stat as \code{"count"}.
\item For more information and other ways to specify the stat, see the
\link[ggplot2:layer_stats]{layer stat} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{...}{Additional parameters to be passed to \code{\link[ggplot2:geom_tile]{ggplot2::geom_tile()}}}

\item{space}{Parameter specifying the separation between marginal tiles and
the main grid.  Describes the distance from the center of the marginal tile
to the center of the nearest main grid tile, divided by the width or height
of the tile.  If a single value is provided, it is used for both left-right
and top-bottom margin tiles.  If two values are provided, the first is used
for left-right margin tiles and the second is used for top-bottom margin
tiles.}

\item{trim}{Should values that are finite in one dimension be dropped if
their finite coordinates lie outside the bounds of the main grid?}

\item{shared}{Should marginal offsets and trimming be calculated separately
for each facet if plots are faceted.  If \code{FALSE}, the default, each facet
will have its own bounds and marginal offsets; if \code{TRUE}, offsets will be
calculated for the full data and shared across all facets.}

\item{npoints}{The number of interpolated values in the x- and y- directions
that are used to generate the smoothed raster function}

\item{tight}{If true, the generated raster will span the precise range of
transformed and plotted data; this will produce a range of tiles that are
strictly smaller than those produced by \link{geom_braid} (as those tiles extend
above and below the plotted tile centers).  If \code{FALSE} (the default), the
interpolated values will be selected to span the same (slightly larger) range
of values that would be covered by running \link{geom_braid} with the same
parameters.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with a
warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{geom}{The geometric object to use to display the data for this layer.
When using a \verb{stat_*()} function to construct a layer, the \code{geom} argument
can be used to override the default coupling between stats and geoms. The
\code{geom} argument accepts the following:
\itemize{
\item A \code{Geom} ggproto subclass, for example \code{GeomPoint}.
\item A string naming the geom. To give the geom as a string, strip the
function name of the \code{geom_} prefix. For example, to use \code{geom_point()},
give the geom as \code{"point"}.
\item For more information and other ways to specify the geom, see the
\link[ggplot2:layer_geoms]{layer geom} documentation.
}}
}
\description{
Summarize and plot measurements of two inputs as a smoothed response surface
}
\details{
Like \link{geom_braid}, this function involves several pre-processing steps to
allow quick visualization of drug combination data. These steps include
summarizing duplicated measurements and offsetting non-finite plotted
coordinates. In addition to these steps, \code{geom_braid_smooth} generates a
regular, densely sampled grid of coordinates and smoothly interpolates the
given data to produces a smoothed raster heatmap.  Smoothing in the x- and
y- directions is governed by the width and height aesthetic respectively; if
these aesthetics are not included, they are estimated from the minimum
spacing of the data.
}
\examples{
surface <- synergisticExample

ggplot(surface,aes(x=concA,y=concB))+
   geom_braid_smooth(aes(fill=measure))+
    scale_x_log10("Drug A")+
    scale_y_log10("Drug B")+
    scale_fill_distiller("Effect",palette="RdYlBu")+
    coord_equal()
}
