% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/braidReport.R
\name{basicBraidAnalysis}
\alias{basicBraidAnalysis}
\title{Basic BRAID Analysis Conversion}
\usage{
basicBraidAnalysis(bfit)
}
\arguments{
\item{bfit}{A BRAID fit object of class \code{braidrm}}
}
\value{
A BRAID analysis object of class \code{braidanalysis} containin only the
results from the given BRAID fit
}
\description{
Basic BRAID Analysis Conversion
}
\details{
While we strongly recommend using the \code{\link[=runBraidAnalysis]{runBraidAnalysis()}} function for a
more complete treatment of a combination; there may be circumstances in
which is necessary or preferable to use an existing BRAID fit object (of
class \code{braidrm}).  Thsi function takes such a fit and wraps it in a minimal
\code{braidAnalysis} object which can then be passed to \code{\link[=makeBraidReport]{makeBraidReport()}}
}
\examples{
surface <- antagonisticExample
fit <- braidrm(measure ~ concA + concB, surface, model="kappa2")

analysis <- basicBraidAnalysis(fit)

names(analysis)
}
