% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sim.brQCA.R
\name{sim.brQCA}
\alias{sim.brQCA}
\title{Simulation Application}
\usage{
sim.brQCA(qca.data, outcome = "OUT", conditions = c(""), sim = 10,
  ncut = 2, type = "crisp", inclcut = "", neg.out = F, verbose = T)
}
\arguments{
\item{qca.data}{the data frame of causal conditions.}

\item{outcome}{the outcome variable (object name) in the QCA data frame of causal conditions; \code{"OUT"} is the outcome variable for an application of QCA. Default set to \code{outcome="OUT"}.}

\item{conditions}{a set of causal conditions. Default set to \code{conditions=c("")}}

\item{sim}{number of simulations to run. Default set to \code{sim=10}.}

\item{ncut}{configurational n levels for inclusion. Default set to \code{ncut=2}.}

\item{type}{type of QCA application, \code{"crisp"} or \code{"fuzzy"} sets. Default set to \code{type = "crisp"}.}

\item{inclcut}{minimum sufficiency score for inclusion. Default set to \code{inclcut=""}.}

\item{neg.out}{[from QCAGUI package] ``Logical, use negation of outcome (ignored if data is a truth table object).'' Default set to \code{neg.out=F}.}

\item{verbose}{prints the system time used to run the simulation and the percent complete. Default set to \code{verbose=T}.}
}
\value{
Simulation information later passed on to conf.table.
}
\description{
Internal function to calculate the Bootstrapped Recommendation.
}

