% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORI.R
\name{drawbetaOR1}
\alias{drawbetaOR1}
\title{Samples \eqn{\beta} in the OR1 model}
\usage{
drawbetaOR1(z, x, w, tau2, theta, invB0, invB0b0)
}
\arguments{
\item{z}{continuous latent values, vector of size \eqn{(n x 1)}.}

\item{x}{covariate matrix of size \eqn{(n x k)} including a column of ones with or without column names.}

\item{w}{latent weights, column vector of size size \eqn{(n x 1)}.}

\item{tau2}{2/(p(1-p)).}

\item{theta}{(1-2p)/(p(1-p)).}

\item{invB0}{inverse of prior covariance matrix of normal distribution.}

\item{invB0b0}{prior mean pre-multiplied by invB0.}
}
\value{
Returns a list with components
\item{\code{beta}: }{\eqn{\beta}, a column vector of size \eqn{(k x 1)}, sampled from its
condtional posterior distribution.}
\item{\code{Btilde}: }{variance parameter for the posterior multivariate normal
 distribution.}
\item{\code{btilde}: }{mean parameter for the
posterior multivariate normal distribution.}
}
\description{
This function samples \eqn{\beta} from its conditional
posterior distribution in the OR1 model (ordinal quantile model with 3 or more
outcomes).
}
\details{
This function samples \eqn{\beta}, a vector, from its conditional posterior distribution
which is an updated multivariate normal distribution.
}
\examples{
set.seed(101)
data("data25j4")
xMat <- data25j4$x
p <- 0.25
n <- dim(xMat)[1]
k <- dim(xMat)[2]
w <- array( (abs(rnorm(n, mean = 2, sd = 1))), dim = c (n, 1))
theta <- 2.666667
tau2 <- 10.66667
z <- array( (rnorm(n, mean = 0, sd = 1)), dim = c(n, 1))
b0 <- array(0, dim = c(k, 1))
B0 <- diag(k)
invB0 <- matrix(c(
     1, 0, 0,
     0, 1, 0,
     0, 0, 1),
     nrow = 3, ncol = 3, byrow = TRUE)
invB0b0 <- invB0 \%*\% b0
output <- drawbetaOR1(z, xMat, w, tau2, theta, invB0, invB0b0)

# output$beta
#   -0.2481837 0.7837995 -3.4680418
}
\references{
Rahman, M. A. (2016). `"Bayesian Quantile Regression for Ordinal Models."`
Bayesian Analysis, 11(1): 1-24. DOI: 10.1214/15-BA939
}
\seealso{
Gibbs sampling, normal distribution,
\link[MASS]{mvrnorm}, \link[pracma]{inv}
}
