% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORI.R
\name{drawwOR1}
\alias{drawwOR1}
\title{Samples latent weight w in the OR1 model}
\usage{
drawwOR1(z, x, beta, tau2, theta, lambda)
}
\arguments{
\item{z}{continuous latent values, vector of size \eqn{(n x 1)}.}

\item{x}{covariate matrix of size \eqn{(n x k)} including a column of ones with or without column names.}

\item{beta}{Gibbs draw of \eqn{\beta}, a column vector of size \eqn{(k x 1)}.}

\item{tau2}{2/(p(1-p)).}

\item{theta}{(1-2p)/(p(1-p)).}

\item{lambda}{index parameter of GIG distribution which is equal to 0.5}
}
\value{
w, a column vector of size \eqn{(n x 1)}, sampled from a GIG distribution.
}
\description{
This function samples latent weight w from a generalized
inverse-Gaussian distribution (GIG) in the OR1 model (ordinal quantile model with 3 or more
outcomes).
}
\details{
This function samples a vector of latent weight w from a GIG distribution.
}
\examples{
set.seed(101)
z <- c(0.9812363, -1.09788, -0.9650175, 8.396556,
 1.39465, -0.8711435, -0.5836833, -2.792464,
 0.1540086, -2.590724, 0.06169976, -1.823058,
 0.06559151, 0.1612763, 0.161311, 4.908488,
 0.6512113, 0.1560708, -0.883636, -0.5531435)
x <- matrix(c(
     1, 1.4747905363, 0.167095186,
     1, -0.3817326861, 0.041879526,
     1, -0.1723095575, -1.414863777,
     1, 0.8266428137, 0.399722073,
     1, 0.0514888733, -0.105132425,
     1, -0.3159992662, -0.902003846,
     1, -0.4490888878, -0.070475600,
     1, -0.3671705251, -0.633396477,
     1, 1.7655601639, -0.702621934,
     1, -2.4543678120, -0.524068780,
     1,  0.3625025618,  0.698377504,
     1, -1.0339179063,  0.155746376,
     1,  1.2927374692, -0.155186911,
     1, -0.9125108094, -0.030513775,
     1,  0.8761233001,  0.988171587,
     1,  1.7379728231,  1.180760114,
     1,  0.7820635770, -0.338141095,
     1, -1.0212853209, -0.113765067,
     1,  0.6311364051, -0.061883874,
     1,  0.6756039688,  0.664490143),
     nrow = 20, ncol = 3, byrow = TRUE)
beta <- c(-1.583533, 1.407158, 2.259338)
tau2 <- 10.66667
theta <- 2.666667
lambda <- 0.5
output <- drawwOR1(z, x, beta, tau2, theta, lambda)

# output
#   0.16135732
#   0.39333080
#   0.80187227
#   2.27442898
#   0.90358310
#   0.99886987
#   0.41515947 ... soon

}
\references{
Rahman, M. A. (2016). “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1): 1-24.  DOI: 10.1214/15-BA939

Devroye, L. (2014). “Random variate generation for the generalized inverse Gaussian
distribution.” Statistics and Computing, 24(2): 239–246. DOI: 10.1007/s11222-012-9367-z
}
\seealso{
GIGrvg, Gibbs sampling, \link[GIGrvg]{rgig}
}
