% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classfunctions.R
\name{BFc.bpnr}
\alias{BFc.bpnr}
\title{Bayes Factors for a Bayesian circular regression model}
\usage{
\method{BFc}{bpnr}(object, hypothesis, type = "anchor")
}
\arguments{
\item{object}{a \code{bpnr object} obtained from the function \code{bpnr()}.}

\item{hypothesis}{the inequality constrained hypothesis to test.}

\item{type}{type of hypothesis to test \code{c("anchor", "isotropic")}. As of
yet only anchor hypotheses can be tested.}
}
\value{
Bayes Factors for inequality constrained hypotheses on mean
  differences.
}
\description{
Outputs Bayes Factors for the circular differences between several levels of
a categorical variable and the baseline.
}
\examples{
library(bpnreg)
fit.Motor <- bpnr(pred.I = Phaserad ~ 1 + Cond, data = Motor,
its = 100, burn = 10, n.lag = 3)
BFc(fit.Motor, hypothesis = "Condsemi.imp < Condimp")

}
