% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classfunctions.R
\name{predict.bpnr}
\alias{predict.bpnr}
\title{Predicted values for a Bayesian circular regression model}
\usage{
\method{predict}{bpnr}(object, ...)
}
\arguments{
\item{object}{a \code{bpnr object} obtained from the function
\code{\link{bpnr}}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a matrix (rows = N, columns = iterations) containing predicted values
  for the circular outcome for each iteration of the MCMC sampler.
}
\description{
Outputs predicted values for a Bayesian circular regression model for each
iteration of the MCMC sampler.
}
\examples{
library(bpnreg)
fit.Motor <- bpnr(pred.I = Phaserad ~ 1 + Cond, data = Motor,
its = 100, burn = 10, n.lag = 3)
predict(fit.Motor)

}
