% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bpc_exports.R
\name{get_waic}
\alias{get_waic}
\title{Tiny wrapper for the WAIC method from the loo package.}
\usage{
get_waic(bpc_object)
}
\arguments{
\item{bpc_object}{a bpc object}
}
\value{
a loo object
}
\description{
This is used to evaluate the fit of the model using the Watanabe-Akaike Information criteria
}
\examples{
\donttest{
m<-bpc(data = tennis_agresti,
player0 = 'player0',
player1 = 'player1',
result_column = 'y',
model_type = 'bt',
solve_ties = 'none')
waic<-get_waic(m)
print(waic)
}
}
\references{
Gelman, Andrew, Jessica Hwang, and Aki Vehtari. Understanding predictive information criteria for Bayesian models. Statistics and computing 24.6 (2014): 997-1016.
}
