% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bpbounds.R
\name{bpbounds}
\alias{bpbounds}
\title{Nonparametric Bounds for the Average Causal Effect due to Balke and Pearl.}
\usage{
bpbounds(p, t = NULL, fmt = "trivariate")
}
\arguments{
\item{p}{Object of class "table" containing either cell counts or conditional
probabilities. For trivariate data these are for the
phenotype/treatment-outcome association given Z, i.e. P(X, Y | Z).

Cell counts could be generated from \code{xtabs(~ x + y + z, data = data)}.
And then conditional probabilities obatained by calling
\code{prop.table(..., margins = 3)} on your object from \code{xtabs()}.

If you only know the conditional probabilities you can enter these, e.g.
for the Balke and Pearl Vitamin A example:\preformatted{cp   = c(.0064, 0, .9936, 0, .0028, .001, .1972, .799)
tabp = as.table(array(
  cp,
  dim = c(2, 2, 2),
  dimnames = list(
    x = c(0, 1),
    y = c(0, 1),
    z = c(0, 1)
  )
))
}

And then call \code{bpbounds()} using this object.

For bivariate data this object contains cell conditional probabilities for
the outcome-instrument (Y|Z) association.}

\item{t}{Specified for bivariate data. Object with
treatment/phenotype-instrument cell counts or conditional probabilities,
i.e. (X|Z).}

\item{fmt}{A character string which sould be either "bivariate"
(i.e. X, Z in one dataset and Y, Z in another dataset) or
"trivariate" (X, Y, Z in the same dataset).}
}
\value{
List with the following elements:
\describe{
\item{fmt}{whether the data is bivariate or trivariate}
\item{nzcats}{2 or 3, the no. instrument categories}
\item{inequality}{Logical, indicating whether the IV inquality is satisfied}
\item{bplb}{Lower bound of ACE}
\item{bpub}{Upper bound of ACE}
\item{bplower}{Vector of lower bound probabilities}
\item{bpupper}{Vector of upper bound probabilities}
\item{p11low}{Lower bound of P(Y=1|do(X=1))}
\item{p11upp}{Upper bound of P(Y=1|do(X=1))}
\item{p10low}{Lower bound of P(Y=1|do(X=0))}
\item{p10upp}{Upper bound of P(Y=1|do(X=0))}
\item{p11lower}{Vector of probabilities for lower bound of P(Y=1|do(X=1))}
\item{p11upper}{Vector of probabilities for upper bound of P(Y=1|do(X=1))}
\item{p10lower}{Vector of probabilities for lower bound of P(Y=1|do(X=0))}
\item{p10upper}{Vector of probabilities for upper bound of P(Y=1|do(X=0))}
\item{crrlb}{Lower bound of CRR}
\item{crrub}{Upper bound of CRR}
\item{monoinequality}{Logical, indicating whether the monoticity inequality
is satisfied}
\item{monobplb}{Lower bound of ACE assuming monotonicity}
\item{monobpub}{Upper bound of ACE assuming monotonicity}
\item{monobplower}{Vector of probabilities for lower bound of ACE assuming
monotonicity}
\item{monobpupper}{Vector of probabilities for upper bound of ACE assuming
monotonicity}
\item{monop11low}{Lower bound of P(Y=1|do(X=1)) assuming monotonicity}
\item{monop11upp}{Upper bound of P(Y=1|do(X=1)) assuming monotonicity}
\item{monop10low}{Lower bound of P(Y=1|do(X=0)) assuming monotonicity}
\item{monop10upp}{Upper bound of P(Y=1|do(X=0)) assuming monotonicity}
\item{monop11lower}{Vector for corresponding bound above}
\item{monop11upper}{Vector for corresponding bound above}
\item{monop10lower}{Vector for corresponding bound above}
\item{monop10upper}{Vector for corresponding bound above}
\item{monocrrlb}{Lower bound of CRR assuming monotonicity}
\item{monocrrub}{Upper bound of CRR assuming monotonicity}
}
}
\description{
Nonparametric Bounds for the Average Causal Effect due to Balke and Pearl.
}
\examples{
\donttest{
# Vitamin A example, using cell counts

require(tidyr)
require(bpbounds)

tab1dat <- data.frame(
  z = c(0, 0, 1, 1, 1, 1, 0, 0),
  x = c(0, 0, 0, 0, 1, 1, 1, 1),
  y = c(0, 1, 0, 1, 0, 1, 0, 1),
  freq = c(74, 11514, 34, 2385, 12, 9663, 0, 0)
)

tab1inddat = uncount(tab1dat, freq)
xt = xtabs(~ x + y + z, data = tab1inddat)
p = prop.table(xt, margin = 3)
bpres = bpbounds(p)
sbpres = summary(bpres)
print(sbpres)
}

\donttest{
# Vitamin A example, using conditional probabilities

require(bpbounds)
cp = c(.0064, 0, .9936, 0, .0028, .001, .1972, .799)
tabp = as.table(array(
  cp,
  dim = c(2, 2, 2),
  dimnames = list(
    x = c(0, 1),
    y = c(0, 1),
    z = c(0, 1)
  )
))
bpbounds(tabp)
}

}
