% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.r
\docType{data}
\name{parse_export_specs}
\alias{parse_export_specs}
\alias{use_call}
\alias{static_assign_calls}
\alias{assign_calls}
\alias{is_static_assign_call}
\alias{is_assign_call}
\alias{block_is_assign}
\alias{block_is_use_call}
\alias{block_is_exported}
\alias{block_name}
\title{Find exported names in parsed module source}
\format{
An object of class \code{call} of length 3.

An object of class \code{list} of length 4.

An object of class \code{list} of length 6.
}
\usage{
parse_export_specs(info, exprs, mod_ns)

use_call

static_assign_calls

assign_calls

is_static_assign_call(call)

is_assign_call(call)

block_is_assign(block)

block_is_use_call(block)

block_is_exported(block)

block_name(block)
}
\arguments{
\item{info}{The module info.}

\item{exprs}{The list of expressions of the parsed module.}

\item{mod_ns}{The module namespace after evaluating the expressions.}

\item{call}{A call to test.}

\item{block}{A roxygen2 block to inspect.}
}
\value{
\code{parse_export_specs} returns a potentially empty character
vector of exported names.
}
\description{
Find exported names in parsed module source
}
\note{
There are two situations in which the \code{@export} tag can be applied:
\enumerate{
  \item When applied to assignments, the assigned name is exported.
  \item When applied to a \code{box::use} call, the imported names are
    exported. This can be the module name itself, any attached names, or
    both. All names introduced by the \code{box::use} call are exported. See
    \code{\link[box]{use}} for the rules governing what names are introduced
    into the scope, and thus exported.
}
In any other situation, applying the \code{@export} tag is an error.
}
\keyword{internal}
