% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{simScenProductTwoPrevs}
\alias{simScenProductTwoPrevs}
\title{Simulation scenario for the product of two prevlaence estimates.}
\usage{
simScenProductTwoPrevs(B = 1000, p1, p2, nExp1, nExp2, alpha = 0.05)
}
\arguments{
\item{B}{The number of simulations to run. Defaults to 1e3.}

\item{p1}{The true value of the first probability parameter.}

\item{p2}{The true value of the second probability parameter.}

\item{nExp1}{The size of each simulated experiment to estimate \code{p1}.}

\item{nExp2}{TThe size of each simulated experiment to estimate \code{p2}.}

\item{alpha}{The confidence level; i.e. the desired coverage is 1-alpha. Defaults to 0.05.}
}
\value{
A list with 2 elements:
   \item{estimate}{A single number, the proportion of simulations for which the confidence interval contained the true parameter value.}
   \item{conf.int}{A 95\% confidence interval for the coverage estimate.}
}
\description{
This is a simulation to compute the coverage of the confidence interval returned by bootComb() in the case of the product of 2 probability parameter estimates.
}
\examples{
\donttest{
simScenProductTwoPrevs(p1=0.35,p2=0.2,nExp1=100,nExp2=1000,B=100)
  # B value only for convenience here
  # Increase B to 1e3 or 1e4 (be aware this may run for some time).
 }

}
