% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{simul_covariates}
\alias{simul_covariates}
\title{Generation of a Design Matrix for Simulations}
\usage{
simul_covariates(n, p_catvar = 10, add_contvars = FALSE, arm_factor = FALSE)
}
\arguments{
\item{n}{(\code{count})\cr number of rows (observations).}

\item{p_catvar}{(\code{count})\cr number of covariates (excluding treatment arm).}

\item{add_contvars}{(\code{flag})\cr whether to add continuous covariates.}

\item{arm_factor}{(\code{flag})\cr whether to make the arm variable a factor.}
}
\value{
The design matrix.
}
\description{
This function uses a block diagonal covariance matrix for the underlying
multivariate normal data to create the design matrix in blocks of 10, see
the details.
}
\details{
The following pattern is repeated for the covariate blocks:
\itemize{
\item The first 5 covariates are uncorrelated with everything.
\item The covariates 6 to 8 have "moderate" correlation (0.25) between each other.
\item The covariates 9 and 10 have "high" correlation (0.5).
}

By default, only the resulting categorical covariates obtained by thresholding
are included. Optionally also the original continuous covariates are included
in the returned design matrix.
}
\examples{
simul_covariates(n = 10, p_catvar = 3, add_contvars = FALSE)
simul_covariates(n = 10, p_catvar = 3, add_contvars = TRUE)
simul_covariates(n = 10, p_catvar = 3, add_contvars = TRUE, arm_factor = TRUE)
}
