% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{preprocess}
\alias{preprocess}
\title{Data Preprocessing}
\usage{
preprocess(trt, subgr, covars, data)
}
\arguments{
\item{trt}{(\code{string})\cr the treatment variable name. The treatment variable
must be a factor with 2 levels where the first level is the control and the
second one the treatment.}

\item{subgr}{(\code{character})\cr vector with the name of the subgroup variables
from which we want to obtain the subgroup treatment effect.}

\item{covars}{(\code{character})\cr vector with the name of the variables that
we want to include in the model. The \code{subgr} variables have to be included
here.}

\item{data}{(\verb{data frame})\cr the data frame with the variables.}
}
\value{
List with \code{design_ia}, \code{design_main}, \code{design_dummy}, \code{subgr_names}.
}
\description{
Function to preprocess the data and obtain the design matrices corresponding
to a model with just interaction of the covariates with the treatment,
to a model with just the main effects and to a model just with the covariates
and one-hot encoding.
}
\examples{
preprocess("arm", c("x_1", "x_2"), c("x_1", "x_2", "x_3"), example_data)
}
