% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bolasso.R
\name{bolasso}
\alias{bolasso}
\title{Bootsrap-enhanced Lasso}
\usage{
bolasso(
  formula,
  data,
  n.boot = 100,
  progress = TRUE,
  implement = "glmnet",
  x = NULL,
  y = NULL,
  ...
)
}
\arguments{
\item{formula}{An optional object of class \link{formula} (or one that can be
coerced to that class): a symbolic description of the model to be fitted.
Can be omitted when \code{x} and \code{y} are non-missing.}

\item{data}{An optional object of class \link{data.frame} that contains the
modeling variables referenced in \code{form}. Can be omitted when \code{x} and \code{y}
are non-missing.}

\item{n.boot}{An integer specifying the number of bootstrap replicates.}

\item{progress}{A boolean indicating whether to display progress across
bootstrap folds.}

\item{implement}{A character; either 'glmnet' or 'gamlr', specifying which
Lasso implementation to utilize. For specific modeling details, see
\code{glmnet::cv.glmnet} or \code{gamlr::cv.gamlr}.}

\item{x}{An optional predictor matrix in lieu of \code{form} and \code{data}.}

\item{y}{An optional response vector in lieu of \code{form} and \code{data}.}

\item{...}{Additional parameters to pass to either
\code{glmnet::cv.glmnet} or \code{gamlr::cv.gamlr}.}
}
\value{
An object of class \code{bolasso}. This object is a list of length
\code{n.boot} of \code{cv.glmnet} or \code{cv.gamlr} objects.
}
\description{
This function implements model-consistent Lasso estimation through the
bootstrap. It supports parallel processing by way of the
\href{https://CRAN.R-project.org/package=future}{future}
package, allowing the user to flexibly specify many parallelization methods.
This method was developed as a variable-selection algorithm, but this package
also supports making ensemble predictions on new data using the bagged Lasso
models.
}
\examples{
mtcars[, c(2, 10:11)] <- lapply(mtcars[, c(2, 10:11)], as.factor)
idx <- sample(nrow(mtcars), 22)
mtcars_train <- mtcars[idx, ]
mtcars_test <- mtcars[-idx, ]

## Formula Interface

# Train model
set.seed(123)
bolasso_form <- bolasso(
  form = mpg ~ .,
  data = mtcars_train,
  n.boot = 20,
  nfolds = 5,
  implement = "glmnet"
)

# Extract selected variables
selected_vars(bolasso_form, threshold = 0.9, select = "lambda.min")

# Bagged ensemble prediction on test data
predict(bolasso_form,
        new.data = mtcars_test,
        select = "lambda.min")

## Alternal Matrix Interface

# Train model
set.seed(123)
bolasso_mat <- bolasso(
  x = model.matrix(mpg ~ . - 1, mtcars_train),
  y = mtcars_train[, 1],
  data = mtcars_train,
  n.boot = 20,
  nfolds = 5,
  implement = "glmnet"
)

# Extract selected variables
selected_vars(bolasso_mat, threshold = 0.9, select = "lambda.min")

# Bagged ensemble prediction on test data
predict(bolasso_mat,
        new.data = model.matrix(mpg ~ . - 1, mtcars_test),
        select = "lambda.min")

}
\references{
\insertRef{DBLP:journals/corr/abs-0804-1302}{bolasso}
}
\seealso{
\link[glmnet:cv.glmnet]{glmnet::cv.glmnet} and \link[gamlr:cv.gamlr]{gamlr::cv.gamlr} for full details on the
respective implementations and arguments that can be passed to \code{...}.
}
