% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bnviewer.R
\name{viewer}
\alias{viewer}
\title{Interactive Bayesian Network Viewer}
\usage{
viewer(
  bayesianNetwork,
  bayesianNetwork.background = NULL,
  bayesianNetwork.title = "",
  bayesianNetwork.subtitle = "",
  bayesianNetwork.footer = "",
  bayesianNetwork.enabled.interactive.mode = FALSE,
  bayesianNetwork.layout = "default",
  bayesianNetwork.width = "100\%",
  bayesianNetwork.height = "500px",
  node.shape = NULL,
  node.label.prefix = "",
  node.colors = list(),
  node.font = list(),
  edges.smooth = TRUE,
  edges.dashes = FALSE,
  options.highlightNearest = TRUE,
  options.nodesIdSelection = FALSE,
  clusters.legend.title = "",
  clusters.legend.options = list(),
  clusters = list()
)
}
\arguments{
\item{bayesianNetwork}{A Bayesian Network structure. (Example : hill-climbing (HC)).}

\item{bayesianNetwork.background}{Bayesian network background}

\item{bayesianNetwork.title}{: String. Bayesian Network title}

\item{bayesianNetwork.subtitle}{: String. Bayesian Network subtitle}

\item{bayesianNetwork.footer}{: String. Bayesian Network footer}

\item{bayesianNetwork.enabled.interactive.mode}{: Boolean. Enabled interactive viewer mode.}

\item{bayesianNetwork.layout}{: String. A layout of a Bayesian Network.
The hierarchical layout the available options are: UD, DU, LR, RL.
To simplify: up-down, down-up, left-right, right-left.
\enumerate{
  \item layout_on_sphere
  \item layout_on_grid
  \item layout_in_circle
  \item layout_as_star
  \item layout_as_tree
  \item layout_with_sugiyama
  \item layout_with_kk
  \item layout_with_dh
  \item layout_with_lgl
  \item layout_with_mds
  \item layout_with_gem
  \item layout_nicely
  \item layout_components
  \item layout_hierarchical_direction_UD
  \item layout_hierarchical_direction_DU
  \item layout_hierarchical_direction_LR
  \item layout_hierarchical_direction_RL
}}

\item{bayesianNetwork.width}{: String. Bayesian Network width}

\item{bayesianNetwork.height}{: String. Bayesian Network height}

\item{node.shape}{: String. A node shape of a Bayesian Network
\enumerate{
  \item dot (default)
  \item circle
  \item ellipse
  \item database
  \item diamond
  \item square
  \item triangle
  \item box
  \item star
  \item text
}}

\item{node.label.prefix}{: String. Adds a prefix to the node label}

\item{node.colors}{: String | named list. Color for the node. Can be 'rgba(120,32,14,1)', '#97C2FC'
(hexa notation on 7 char without transparency) or 'red'.
Can be just one color, or a list with several elements:

\enumerate{
  \item "background" : String. Default to '#97C2FC'. Background color for the node.
  \item "border" : String. Default to '#2B7CE9'. Border color for the node.
  \item "highlight" : String | named list, Color of the node when selected.
  \enumerate{
     \item "background" : String. Default to '#97C2FC'. Background color for the node when selected.
     \item "border" : String. Default to '#2B7CE9'. Border color for the node when selected.
  }
}}

\item{node.font}{Node Font : Array. Example list(color = "black", face="Arial")}

\item{edges.smooth}{: Boolean. When true, the edge is drawn as a dynamic quadratic bezier curve.}

\item{edges.dashes}{: Array or Boolean. Default to false. When true, the edge will be drawn as a dashed line.}

\item{options.highlightNearest}{: Boolean. Default to true. Highlight nearest when clicking a node.}

\item{options.nodesIdSelection}{: Boolean. Default to false. Add an id node selection creating an HTML select element.}

\item{clusters.legend.title}{: Array.  Get details in the example.}

\item{clusters.legend.options}{: Array of Array. Get details in the example.}

\item{clusters}{: Array of Array. Get details in the example.}
}
\description{
Interactive Bayesian Network Viewer
}
\examples{

library(bnlearn)
library(bnviewer)

data("alarm")
bayesianNetwork = hc(alarm)

viewer(bayesianNetwork,
       bayesianNetwork.background = "-webkit-radial-gradient(center, ellipse cover,
                                                             rgba(255,255,255,1) 0\%,
                                                             rgba(246,246,246,1) 47\%,
                                                             rgba(237,237,237,1) 100\%)",
       bayesianNetwork.width = "100\%",
       bayesianNetwork.height = "100vh",
       bayesianNetwork.layout = "layout_components",
       bayesianNetwork.title="<br>Discrete Bayesian Network - Alarm",
       bayesianNetwork.subtitle = "Monitoring of emergency care patients",

       node.colors = list(background = "white",
                          border = "black",
                          highlight = list(background = "#e91eba",
                                           border = "black")),
       node.font = list(color = "black", face="Arial"),

       clusters.legend.title = list(text = "<b>Legend</b> <br> Variable Categories",
                                    style = "font-size:18px;
                                             font-family:Arial;
                                             color:black;
                                             text-align:center;"),
       clusters.legend.options = list(
         list(label = "Pressure",
              shape = "icon",
              icon = list(code = "f1ce",
                          size = 50,
                          color = "#e91e63")),
         list(label = "Volume",
              shape = "icon",
              icon = list(code = "f140",
                          size = 50,
                          color = "#03a9f4")),
         list(label = "Ventilation",
              shape = "icon",
              icon = list(code = "f192",
                          size = 50,
                          color = "#4caf50")),
         list(label = "Saturation",
              shape = "icon",
              icon = list(code = "f10c",
                          size = 50,
                          color = "#ffc107"))
       ),

       clusters = list(
         list(label = "Pressure",
              shape = "icon",
              icon = list(code = "f1ce", color = "#e91e63"),
              nodes = list("CVP","BP","HRBP","PAP","PRSS")),
         list(label = "Volume",
              shape = "icon",
              icon = list(code = "f140", color = "#03a9f4"),
              nodes = list("MINV","MVS","LVV","STKV")),
         list(label = "Ventilation",
              shape = "icon",
              icon = list(code = "f192", color = "#4caf50"),
              nodes = list("VALV","VLNG","VTUB","VMCH")),
         list(label = "Saturation",
              shape = "icon",
              icon = list(code = "f10c", color = "#ffc107"),
              nodes = list("HRSA","SAO2","PVS"))
       )
)

}
\references{
See online documentation \url{http://robsonfernandes.net/bnviewer}

See the code fontAwesome for icons in groups and nodes \url{https://fontawesome.com/v4.7.0/cheatsheet/}
}
