% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/BNDataset-methods.R
\docType{methods}
\name{bootstrap}
\alias{bootstrap}
\alias{bootstrap,BNDataset}
\alias{bootstrap,BNDataset-method}
\title{Perform bootstrap.}
\usage{
bootstrap(object, num.boots = 100, seed = 0, imputation = FALSE,
  k.impute = 10)

\S4method{bootstrap}{BNDataset}(object, num.boots = 100, seed = 0,
  imputation = FALSE, k.impute = 10)
}
\arguments{
\item{object}{the \code{\link{BNDataset}} object.}

\item{num.boots}{number of sampled datasets for bootstrap.}

\item{seed}{random seed.}

\item{imputation}{\code{TRUE} if imputation has to be performed. Default is \code{FALSE}.}

\item{k.impute}{number of neighbours to be used; for discrete variables we use mode, for continuous variables the median value is instead taken (useful only if imputation == TRUE).}
}
\description{
Create a list of \code{num.boots} samples of the original dataset.
}
\examples{
\dontrun{
dataset <- BNDataset("file.data", "file.header")
dataset <- bootstrap(dataset, num.boots = 1000)
}
}

