% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpint.R
\name{rpint}
\alias{rpint}
\title{Draw intermediate subpopulation allele frequencies}
\usage{
rpint(pAnc, F)
}
\arguments{
\item{pAnc}{The length-\eqn{m} vector of ancestral allele frequencies per locus}

\item{F}{The length-\eqn{k} vector of subpopulation \eqn{F_{ST}}{FST} values}
}
\value{
The \eqn{m \times k}{m-by-k} matrix of intermediate subpopulation allele frequencies
}
\description{
Intermediate subpopulation allele frequencies \eqn{p_i^{S_u}} for subpopulation \eqn{S_u} at locus \eqn{i} are drawn from the Balding-Nichols distribution with ancestral allele frequency \eqn{p_i^T} and \eqn{F_{ST}}{FST} parameter \eqn{f^T_{S_u}} as
\deqn{p_i^{S_u} \sim \mbox{Beta}(\nu_u p_i^T, \nu_u (1-p_i^T)),}
where \eqn{\nu_u = 1/f^T_{S_u} - 1}.
Below \eqn{m} is the number of loci and \eqn{k} is the number of subpopulations.
}
\examples{
m <- 10 # number of loci
pAnc <- rpanc(m) # random vector of ancestral allele frequencies
F <- c(0.1, 0.3) # FST values for two subpops
B <- rpint(pAnc, F) # matrix of intermediate subpop allele freqs

}
