% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frobenius.R
\name{Fro.CI}
\alias{Fro.CI}
\title{Frobenius norm for \code{CI}}
\usage{
\method{Fro}{CI}(x, type, entry, delta, log = TRUE, ...)
}
\arguments{
\item{x}{object of class \code{CI}.}

\item{type}{character string. Type of model-preserving co-variation: either \code{"total"}, \code{"partial"}, \code{row}, \code{column} or \code{all}. If \code{all} the Frobenius norm is computed for every type of co-variation matrix.}

\item{entry}{a vector of length 2 indicating the entry of the covariance matrix to vary.}

\item{delta}{numeric vector with positive elements, including the variation parameters that act multiplicatively.}

\item{log}{boolean value. If \code{TRUE}, the logarithm of the Frobenius norm is returned. Set by default to \code{TRUE}.}

\item{...}{additional arguments for compatibility.}
}
\value{
A dataframe including in the first column the variations performed, and in the following columns the corresponding Frobenius norms for the chosen model-preserving co-variations.
}
\description{
\code{Fro.CI} returns the Frobenius norm between an object of class \code{CI}  and its update after a model-preserving parameter variation.
}
\details{
Computation of the Frobenius norm between a Bayesian network and its updated version after a model-preserving variation.
}
\examples{
Fro(synthetic_ci,"total",c(1,1),seq(0.9,1.1,0.01))
Fro(synthetic_ci,"partial",c(1,4),seq(0.9,1.1,0.01))
Fro(synthetic_ci,"column",c(1,2),seq(0.9,1.1,0.01))
Fro(synthetic_ci,"row",c(3,2),seq(0.9,1.1,0.01))

}
\references{
C. Görgen & M. Leonelli (2020), Model-preserving sensitivity analysis for families of Gaussian distributions.  Journal of Machine Learning Research, 21: 1-32.
}
\seealso{
\code{\link{KL.GBN}}, \code{\link{KL.CI}}, \code{\link{Fro.GBN}}, \code{\link{Jeffreys.GBN}}, \code{\link{Jeffreys.CI}}
}
