% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KL.R
\name{KL.bn.fit}
\alias{KL.bn.fit}
\title{KL Divergence for \code{bn.fit}}
\usage{
\method{KL}{bn.fit}(
  x,
  node,
  value_node,
  value_parents,
  new_value,
  covariation = "proportional",
  ...
)
}
\arguments{
\item{x}{object of class \code{bn.fit}.}

\item{node}{character string. Node of which the conditional probability distribution is being changed.}

\item{value_node}{character string. Level of \code{node}.}

\item{value_parents}{character string. Levels of \code{node}'s parents. The levels should be defined according to the order of the parents in \code{bnfit[[node]][["parents"]]}. If \code{node} has no parents, then it should be set to \code{NULL}.}

\item{new_value}{numeric vector with elements between 0 and 1. Values to which the parameter should be updated. It can take a specific value or more than one. In the case of more than one value, these should be defined through a vector with an increasing order of the elements. \code{new_value} can also be set to the character string \code{all}: in this case a sequence of possible parameter changes ranging from 0.05 to 0.95 is considered.}

\item{covariation}{character string. Co-variation scheme to be used for the updated Bayesian network. Can take values \code{uniform}, \code{proportional}, \code{orderp}, \code{all}. If equal to \code{all}, uniform, proportional and order-preserving co-variation schemes are used. Set by default to \code{proportional}.}

\item{...}{additional parameters to be added to the plot.}
}
\value{
A dataframe with the varied parameter and the KL divergence for different co-variation schemes. If \code{plot = TRUE} the function returns a plot of the KL divergences.
}
\description{
\code{KL.bn.fit} returns the Kullback-Leibler (KL) divergence between a Bayesian network and its update after parameter variation.
}
\details{
The Bayesian network on which parameter variation is being conducted should be expressed as a \code{bn.fit} object.
The name of the node to be varied, its level and its parent's levels should be specified.
The parameter variation specified by the function is:

 P ( \code{node} = \code{value_node} | parents = \code{value_parents} ) = \code{new_value}
}
\examples{
KL(synthetic_bn, "y2", "1", "2", "all", "all")
KL(synthetic_bn, "y1", "2", NULL, 0.3, "all")

}
\references{
Kullback, S., & Leibler, R. A. (1951). On information and sufficiency. The annals of mathematical statistics, 22(1), 79-86.

Leonelli, M., Goergen, C., & Smith, J. Q. (2017). Sensitivity analysis in multilinear probabilistic models. Information Sciences, 411, 84-97.
}
\seealso{
\code{\link{CD}}
}
