% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frobenius.R
\name{Fro.GBN}
\alias{Fro.GBN}
\title{Frobenius norm for \code{GBN}}
\usage{
\method{Fro}{GBN}(x, entry, delta, log = TRUE, ...)
}
\arguments{
\item{x}{object of class \code{GBN}.}

\item{entry}{a vector of length 2 indicating the entry of the covariance matrix to vary.}

\item{delta}{numeric vector, including the variation parameters that act additively.}

\item{log}{boolean value. If \code{TRUE}, the logarithm of the Frobenius norm is returned. Set by default to \code{TRUE}.}

\item{...}{additional arguments for compatibility.}
}
\value{
A dataframe including in the first column the variations performed and in the second column the corresponding Frobenius norm.
}
\description{
\code{Fro.GBN} returns the Frobenius norm between between an object of class \code{GBN}  and its update after a standard parameter variation.
}
\details{
Computation of the Frobenius norm between a Bayesian network and the additively perturbed Bayesian network, where the perturbation is either to the mean vector or to the covariance matrix. The Frobenius norm is not computed for perturbations of the mean since it is always equal to zero.
}
\examples{
Fro(synthetic_gbn,c(3,3),seq(-1,1,0.1))

}
\seealso{
\code{\link{KL.GBN}}, \code{\link{KL.CI}}, \code{\link{Fro.CI}}, \code{\link{Jeffreys.GBN}}, \code{\link{Jeffreys.CI}}
}
