#' resilience Bayesian Network
#'
#'
#' Quantifying resilience of socio-ecological systems through dynamic Bayesian networks.
#' @usage NULL
#'
#' @format
#' A discrete Bayesian network for the evaluation and modeling of socio-ecological systems structure. Probabilities were given within the referenced paper. The vertices are:
#' \describe{
#'   \item{Absorption}{1920-1960 (false, true);}
#'   \item{Absorption1}{1960-1980 (false, true);}
#'   \item{Absorption2}{1980-2019 (false, true);}
#'   \item{Adaptation}{1920-1960 (false, true);}
#'   \item{Adaptation1}{1960-1980 (false, true);}
#'   \item{Adaptation2}{1980-2019 (false, true);}
#'   \item{Autonomy}{Development of subsistence means and a market economy in which inhabitants own the means of production and influence the dynamics of production processes: 1920-1960 (deficient, low);}
#'   \item{Autonomy1}{As Autonomy: 1960-1980 (deficient, low);}
#'   \item{Autonomy1}{As Autonomy: 1989-2019 (low, moderate);}
#'   \item{Connectivity}{The concept refers to a device's availability to be connected to another or a network. The connectivity emphasizes communicational, social and infrastructural dimensions: 1920-1960 (deficient, low);};
#'   \item{Connectivity1}{As Connectivity: 1960-1980 (low, moderate);}
#'   \item{Connectivity2}{As Connectivity: 1980-2019 (high, moderate);}
#'   \item{Density}{Average number of inhabitants of a country, region, urban or rural area in relation to a given unit area of the territory where that country, region or area is located: 1920-1960 (low, moderate);}
#'   \item{Density1}{As Density: 1960-1980 (low, moderate);}
#'   \item{Density2}{As Density: 1980-2019 (high, moderate);}
#'   \item{Diversity}{Palynological diversity calculated using the palynological richness from the Monquentiva pollen record. This variable indicates the diversity of vegetation represented in the pollen record: 1920-1960 (low, moderate)}
#'   \item{Diversity1}{As Diversity: 1960-1980 (high, low, moderate);}
#'   \item{Diversity2}{As Diversity: 1980-2019 (high, moderate);}
#'   \item{FCover}{Percentage of tree taxa calculated from the Monquentiva pollen record: 1920-1960 (low, moderate);}
#'   \item{FCover1}{As FCover: 1960-1980 (low, moderate);}
#'   \item{FCover2}{As FCover: 1980-2019 (high, low, moderate);}
#'   \item{Fires}{Fire activity at local and regional levels from the Monquentiva charcoal record. The fire record is obtained from the analysis of charcoal in the Monquentiva sediments: 1920-1960 (high, moderate);}
#'   \item{Fires1}{As Fires: 1960-1980 (high, low, moderate);}
#'   \item{Fires2}{As Fires: 1980-2019 (low, moderate);}
#'   \item{Function}{1920-1960 (false, true);}
#'   \item{Function1}{1960-1980 (false, true);}
#'   \item{Function2}{1980-2019 (false, true);}
#'   \item{Organization}{: 1920-1960 (deficient, low);}
#'   \item{Organization1}{As Organization: 1960-1980 (low, moderate);}
#'   \item{Organization2}{As Organization: 1980-2019 (high, moderate);}
#'   \item{Precipitation}{Annual precipitation recorded at the meteorological station No3506029, Embalse Tominé, Guatavita, Colombia: 1920-1960 (high, low, moderate);}
#'   \item{Precipitation1}{As Precipitation: 1960-1980 (low, moderate);}
#'   \item{Precipitation2}{As Precipitation: 1980-2019 (high, low, moderate);}
#'   \item{Transformation}{1920-1960 (true, false);}
#'   \item{Transformation1}{1960-1980 (true, false);}
#'   \item{Transformation2}{1980-2019 (true, false);}
#' }
#'
#' @return An object of class \code{bn.fit}. Refer to the documentation of \code{bnlearn} for details.
#' @keywords NULL
#' @importClassesFrom bnlearn bn.fit
#' @references Franco-Gaviria, F., Amador-Jimenez, M., Millner, N., Durden, C., & Urrego, D. H. (2022). Quantifying resilience of socio-ecological systems through dynamic Bayesian networks. Frontiers in Forests and Global Change, 5, 889274.
"resilience"
