% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BCauchy.R
\name{BCauchy}
\alias{BCauchy}
\title{Cauchy prior simulation example.}
\usage{
BCauchy(
  method = "exact",
  true.theta = 1,
  n = 25,
  N = 10000,
  rseed = 44,
  tuning.sd = 1
)
}
\arguments{
\item{method}{Which method or package to use. Possibilities are: 
\itemize{  
\item{"exact" }{Use exact numerical integration.}  
\item{"importance" }{Use importance sampling with the prior distribution as the importance sampling distribution.}
\item{"rejection" }{Use rejection sampling with the prior distribution as the importance sampling distribution.}
\item{"independence" }{Use the Metropolis-Hastings independence sampler with the prior distribution as the proposal distribution.}
\item{"randomwalk" }{Use the Metropolis-Hastings random-walk sampler with normal distribution 
with mean 0 and variance (tuning.sd)^2 as the increment distribution.}
}}

\item{true.theta}{True value of theta with a default value of 5.}

\item{n}{Data sample size; defaults to 100.}

\item{N}{is the number of Monte Carlo samples.}

\item{rseed}{is the random number seed for drawing data samples.}

\item{tuning.sd}{is the standard deviation of the proposal increment distribution for the random walk sampler.}
}
\value{
A list containing the estimated posterior mean, ybar (the data mean)
and the values of the numerator and the denominator integrals
The routine simulates n observations from N(theta, 1). 
Mean of the simulated data values are returned as ybar.
}
\description{
Cauchy prior simulation example.
}
\examples{
\donttest{
BCauchy(true.theta = 1, n=25) 
BCauchy(true.theta = 5, n=100) 
BCauchy(method="importance", true.theta = 1, n=25) 
BCauchy(method="importance", true.theta = 1, n=25, N=20000) 
BCauchy(method="rejection", true.theta = 1, n=25) 
BCauchy(method="independence", true.theta = 1, n=25) 
BCauchy(method="randomwalk", true.theta = 1, n=25, tuning.sd =1) 
}
}
