// Generated by rstantools.  Do not edit by hand.

/*
    bmstdr is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    bmstdr is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with bmstdr.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_spatial_model_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_spatial_model");
    reader.add_event(62, 60, "end", "model_spatial_model");
    return reader;
}
#include <stan_meta_header.hpp>
class model_spatial_model
  : public stan::model::model_base_crtp<model_spatial_model> {
private:
        int n;
        int p;
        vector_d y;
        matrix_d X;
        matrix_d dist;
        double phi;
        vector_d priorsigma2;
        vector_d priortau2;
        double delta;
        vector_d mu_0;
public:
    model_spatial_model(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_spatial_model(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_spatial_model_namespace::model_spatial_model";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 5;
            context__.validate_dims("data initialization", "n", "int", context__.to_vec());
            n = int(0);
            vals_i__ = context__.vals_i("n");
            pos__ = 0;
            n = vals_i__[pos__++];
            check_greater_or_equal(function__, "n", n, 0);
            current_statement_begin__ = 6;
            context__.validate_dims("data initialization", "p", "int", context__.to_vec());
            p = int(0);
            vals_i__ = context__.vals_i("p");
            pos__ = 0;
            p = vals_i__[pos__++];
            check_greater_or_equal(function__, "p", p, 0);
            current_statement_begin__ = 7;
            validate_non_negative_index("y", "n", n);
            context__.validate_dims("data initialization", "y", "vector_d", context__.to_vec(n));
            y = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < y_j_1_max__; ++j_1__) {
                y(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 8;
            validate_non_negative_index("X", "n", n);
            validate_non_negative_index("X", "p", p);
            context__.validate_dims("data initialization", "X", "matrix_d", context__.to_vec(n,p));
            X = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(n, p);
            vals_r__ = context__.vals_r("X");
            pos__ = 0;
            size_t X_j_2_max__ = p;
            size_t X_j_1_max__ = n;
            for (size_t j_2__ = 0; j_2__ < X_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < X_j_1_max__; ++j_1__) {
                    X(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 9;
            validate_non_negative_index("dist", "n", n);
            validate_non_negative_index("dist", "n", n);
            context__.validate_dims("data initialization", "dist", "matrix_d", context__.to_vec(n,n));
            dist = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(n, n);
            vals_r__ = context__.vals_r("dist");
            pos__ = 0;
            size_t dist_j_2_max__ = n;
            size_t dist_j_1_max__ = n;
            for (size_t j_2__ = 0; j_2__ < dist_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < dist_j_1_max__; ++j_1__) {
                    dist(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 10;
            context__.validate_dims("data initialization", "phi", "double", context__.to_vec());
            phi = double(0);
            vals_r__ = context__.vals_r("phi");
            pos__ = 0;
            phi = vals_r__[pos__++];
            check_greater_or_equal(function__, "phi", phi, 0.00001);
            current_statement_begin__ = 11;
            validate_non_negative_index("priorsigma2", "2", 2);
            context__.validate_dims("data initialization", "priorsigma2", "vector_d", context__.to_vec(2));
            priorsigma2 = Eigen::Matrix<double, Eigen::Dynamic, 1>(2);
            vals_r__ = context__.vals_r("priorsigma2");
            pos__ = 0;
            size_t priorsigma2_j_1_max__ = 2;
            for (size_t j_1__ = 0; j_1__ < priorsigma2_j_1_max__; ++j_1__) {
                priorsigma2(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "priorsigma2", priorsigma2, 0);
            current_statement_begin__ = 12;
            validate_non_negative_index("priortau2", "2", 2);
            context__.validate_dims("data initialization", "priortau2", "vector_d", context__.to_vec(2));
            priortau2 = Eigen::Matrix<double, Eigen::Dynamic, 1>(2);
            vals_r__ = context__.vals_r("priortau2");
            pos__ = 0;
            size_t priortau2_j_1_max__ = 2;
            for (size_t j_1__ = 0; j_1__ < priortau2_j_1_max__; ++j_1__) {
                priortau2(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "priortau2", priortau2, 0);
            // initialize transformed data variables
            current_statement_begin__ = 17;
            delta = double(0);
            stan::math::fill(delta, DUMMY_VAR__);
            stan::math::assign(delta,1e-5);
            current_statement_begin__ = 18;
            validate_non_negative_index("mu_0", "n", n);
            mu_0 = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            stan::math::fill(mu_0, DUMMY_VAR__);
            stan::math::assign(mu_0,rep_vector(0, n));
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 24;
            validate_non_negative_index("beta", "p", p);
            num_params_r__ += p;
            current_statement_begin__ = 25;
            num_params_r__ += 1;
            current_statement_begin__ = 26;
            validate_non_negative_index("eta", "n", n);
            num_params_r__ += n;
            current_statement_begin__ = 27;
            num_params_r__ += 1;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_spatial_model() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 24;
        if (!(context__.contains_r("beta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        validate_non_negative_index("beta", "p", p);
        context__.validate_dims("parameter initialization", "beta", "vector_d", context__.to_vec(p));
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta(p);
        size_t beta_j_1_max__ = p;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            beta(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(beta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 25;
        if (!(context__.contains_r("sigma_sq")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma_sq missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma_sq");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "sigma_sq", "double", context__.to_vec());
        double sigma_sq(0);
        sigma_sq = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, sigma_sq);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma_sq: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 26;
        if (!(context__.contains_r("eta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable eta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("eta");
        pos__ = 0U;
        validate_non_negative_index("eta", "n", n);
        context__.validate_dims("parameter initialization", "eta", "vector_d", context__.to_vec(n));
        Eigen::Matrix<double, Eigen::Dynamic, 1> eta(n);
        size_t eta_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
            eta(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(eta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable eta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 27;
        if (!(context__.contains_r("tau_sq")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable tau_sq missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("tau_sq");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "tau_sq", "double", context__.to_vec());
        double tau_sq(0);
        tau_sq = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, tau_sq);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable tau_sq: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 24;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta;
            (void) beta;  // dummy to suppress unused var warning
            if (jacobian__)
                beta = in__.vector_constrain(p, lp__);
            else
                beta = in__.vector_constrain(p);
            current_statement_begin__ = 25;
            local_scalar_t__ sigma_sq;
            (void) sigma_sq;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_sq = in__.scalar_lb_constrain(0, lp__);
            else
                sigma_sq = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 26;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> eta;
            (void) eta;  // dummy to suppress unused var warning
            if (jacobian__)
                eta = in__.vector_constrain(n, lp__);
            else
                eta = in__.vector_constrain(n);
            current_statement_begin__ = 27;
            local_scalar_t__ tau_sq;
            (void) tau_sq;  // dummy to suppress unused var warning
            if (jacobian__)
                tau_sq = in__.scalar_lb_constrain(0, lp__);
            else
                tau_sq = in__.scalar_lb_constrain(0);
            // model body
            {
            current_statement_begin__ = 34;
            validate_non_negative_index("xbmodel", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> xbmodel(n);
            stan::math::initialize(xbmodel, DUMMY_VAR__);
            stan::math::fill(xbmodel, DUMMY_VAR__);
            current_statement_begin__ = 35;
            validate_non_negative_index("dats", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> dats(n);
            stan::math::initialize(dats, DUMMY_VAR__);
            stan::math::fill(dats, DUMMY_VAR__);
            current_statement_begin__ = 36;
            validate_non_negative_index("L", "n", n);
            validate_non_negative_index("L", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> L(n, n);
            stan::math::initialize(L, DUMMY_VAR__);
            stan::math::fill(L, DUMMY_VAR__);
            current_statement_begin__ = 37;
            validate_non_negative_index("Sigma", "n", n);
            validate_non_negative_index("Sigma", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> Sigma(n, n);
            stan::math::initialize(Sigma, DUMMY_VAR__);
            stan::math::fill(Sigma, DUMMY_VAR__);
            current_statement_begin__ = 38;
            local_scalar_t__ u(DUMMY_VAR__);
            (void) u;  // dummy to suppress unused var warning
            stan::math::initialize(u, DUMMY_VAR__);
            stan::math::fill(u, DUMMY_VAR__);
            current_statement_begin__ = 43;
            stan::math::assign(xbmodel, multiply(X, beta));
            current_statement_begin__ = 44;
            for (int i = 1; i <= n; ++i) {
                current_statement_begin__ = 45;
                for (int j = 1; j <= n; ++j) {
                    current_statement_begin__ = 46;
                    stan::model::assign(Sigma, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                (sigma_sq * stan::math::exp(((-(1) * phi) * get_base1(dist, i, j, "dist", 1)))), 
                                "assigning variable Sigma");
                }
                current_statement_begin__ = 48;
                stan::model::assign(Sigma, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                            (get_base1(Sigma, i, i, "Sigma", 1) + delta), 
                            "assigning variable Sigma");
            }
            current_statement_begin__ = 50;
            stan::math::assign(L, cholesky_decompose(Sigma));
            current_statement_begin__ = 52;
            lp_accum__.add(multi_normal_cholesky_log<propto__>(eta, mu_0, L));
            current_statement_begin__ = 53;
            lp_accum__.add(inv_gamma_log<propto__>(sigma_sq, get_base1(priorsigma2, 1, "priorsigma2", 1), get_base1(priorsigma2, 2, "priorsigma2", 1)));
            current_statement_begin__ = 54;
            lp_accum__.add(inv_gamma_log<propto__>(tau_sq, get_base1(priortau2, 1, "priortau2", 1), get_base1(priortau2, 2, "priortau2", 1)));
            current_statement_begin__ = 56;
            lp_accum__.add(normal_log<propto__>(y, add(xbmodel, eta), stan::math::sqrt(tau_sq)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("beta");
        names__.push_back("sigma_sq");
        names__.push_back("eta");
        names__.push_back("tau_sq");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(p);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_spatial_model_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta = in__.vector_constrain(p);
        size_t beta_j_1_max__ = p;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            vars__.push_back(beta(j_1__));
        }
        double sigma_sq = in__.scalar_lb_constrain(0);
        vars__.push_back(sigma_sq);
        Eigen::Matrix<double, Eigen::Dynamic, 1> eta = in__.vector_constrain(n);
        size_t eta_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
            vars__.push_back(eta(j_1__));
        }
        double tau_sq = in__.scalar_lb_constrain(0);
        vars__.push_back(tau_sq);
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            if (!include_gqs__ && !include_tparams__) return;
            if (!include_gqs__) return;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_spatial_model";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t beta_j_1_max__ = p;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_sq";
        param_names__.push_back(param_name_stream__.str());
        size_t eta_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "eta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau_sq";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
        }
        if (!include_gqs__) return;
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t beta_j_1_max__ = p;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_sq";
        param_names__.push_back(param_name_stream__.str());
        size_t eta_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "eta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau_sq";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
        }
        if (!include_gqs__) return;
    }
}; // model
}  // namespace
typedef model_spatial_model_namespace::model_spatial_model stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
