% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{calculate_validation_statistics}
\alias{calculate_validation_statistics}
\title{Calculates the four validation statistics: RMSE, MAE, CRPS and coverage
given the observed values and MCMC iterates.}
\usage{
calculate_validation_statistics(yval, yits, level = 95, summarystat = "mean")
}
\arguments{
\item{yval}{A vector containing n observed values of the response 
variable.}

\item{yits}{A n by N matrix of predictive samples from the 
n observations contained in yval.}

\item{level}{The nominal coverage level, defaults to 95\%.}

\item{summarystat}{Summary statistics to use to calculate the validation 
predictions from the samples. It should be a function like mean or 
median which can be calculated by R. The default is mean.}
}
\value{
A list giving the rmse, mae, crps and coverage.
}
\description{
Calculates the four validation statistics: RMSE, MAE, CRPS and coverage
given the observed values and MCMC iterates.
}
\examples{
set.seed(4)
vrows <- sample(nrow(nysptime), 100)
M1 <- Bsptime(model="lm", formula=y8hrmax~xmaxtemp+xwdsp+xrh, data=nysptime, 
validrows=vrows, scale.transform = "SQRT")
valstats <- calculate_validation_statistics(M1$yobs_preds$y8hrmax, 
yits=t(M1$valpreds))
unlist(valstats)
}
