% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bmoving_sptime.R
\name{Bmoving_sptime}
\alias{Bmoving_sptime}
\title{Model fitting and validation for spatio-temporal data from moving sensors in time.}
\usage{
Bmoving_sptime(
  formula,
  data,
  coordtype,
  coords,
  prior.sigma2 = c(2, 1),
  prior.tau2 = c(2, 1),
  prior.phi = NULL,
  prior.phi.param = NULL,
  scale.transform = "NONE",
  ad.delta = 0.8,
  t.depth = 12,
  s.size = 0.01,
  N = 2500,
  burn.in = 1000,
  no.chains = 1,
  validrows = 10,
  predspace = FALSE,
  newdata = NULL,
  mchoice = TRUE,
  plotit = FALSE,
  rseed = 44,
  verbose = TRUE,
  knots.coords = NULL,
  g_size = 5
)
}
\arguments{
\item{formula}{An object of class "formula" (or one that can be coerced to that class):
a symbolic description of the model to be fitted.}

\item{data}{The data frame for which the model formula is to be fitted.
The data frame should be in long format having one row for each location and  time
combination. The data frame must be ordered by time within each site, and should
optionally have a column, named s.index,  providing the site indices.
Thus the data,  with n sites and T times within each site, should be
organized in the order: (s1, t1), (s1, t2), ... (s1, T), ... (sn, t1), ... (sn, T). 
The data frame should also contain two columns giving the coordinates of the
locations for spatio temporal model fitting.}

\item{coordtype}{Type of coordinates: utm, lonlat or plain with utm 
(supplied in meters) as the default. Distance will be calculated in units of kilometer
if this argument is either utm or lonlat. Euclidean distance will be calculated 
if this is given as the third type plain.  If  distance in meter is to be calculated 
then coordtype should be passed on as plain although the coords are supplied in UTM.}

\item{coords}{A vector of size 2 giving the column numbers of the data 
frame which contain the coordinates of the data locations.  
Here the supplied data frame must contain a column named `time` which 
should indicate the time index of the data row. The values in the column `time` 
should be positive integers starting from 1.}

\item{prior.sigma2}{Shape and scale parameter value for the gamma prior on 1/sigma^2, the precision.}

\item{prior.tau2}{Shape and scale parameter value for the gamma prior on tau^2, the nugget effect.}

\item{prior.phi}{Specifies the prior distribution for \eqn{\phi} only when 
package is one of Stan, spTimer or spTDyn.  Distribution options 
uniform specified by "Unif" and gamma specified by "Gamm" have been implemented in 
both Stan and spTimer. Additionally a half-Cauchy prior distribution specified as "Cauchy"
has been implemented in Stan. In the case of spTimer the uniform distribution is discrete 
while in the case of Stan the uniform distribution is continuous. In the case of 
spTimer the option "FIXED" can be used to keep the value fixed. In that case the fixed value 
can be given by by a scalar value as the argument \code{prior.phi.param} below or it can be left 
unspecified in which case the  fixed value of \eqn{\phi} is chosen as 3/maximum distance between the 
data locations.  The  "FIXED" option is not available for the Stan package.}

\item{prior.phi.param}{Lower and upper limits of the uniform prior distribution for
phi the spatial decay parameter. For the default uniform distribution the values correspond
to an effective range that is between 1\% and 100\% of the maximum distance
between the data locations. For the Gamma distribution the default values are 2 and 1
and for the Cauchy distribution the default values are 0, 1 which specifies
a half-Cauchy distribution in \eqn{(0, \infty)}.}

\item{scale.transform}{Transformation of the response variable. It can take three values: SQRT, LOG or NONE.
Default value is "NONE".}

\item{ad.delta}{Adaptive delta controlling the behavior of Stan during fitting.}

\item{t.depth}{Maximum allowed tree depth in the fitting process of Stan.}

\item{s.size}{step size in the fitting process of Stan.}

\item{N}{MCMC sample size.}

\item{burn.in}{How many initial iterations to discard. 
Only relevant for MCMC based model fitting, i.e., when package is spBayes or Stan.}

\item{no.chains}{Number of parallel chains to run in Stan.}

\item{validrows}{Either a number of randomly selected data rows to validate
or a vector giving the row numbers of the data set for validation.}

\item{predspace}{A 0-1 flag indicating whether spatial predictions are to be made.}

\item{newdata}{A new data frame with the same column structure as the model fitting data set.}

\item{mchoice}{Logical scalar value: whether model choice statistics should be calculated.}

\item{plotit}{Logical scalar value: whether to plot the predictions against the observed values.}

\item{rseed}{Random number seed that controls the starting point for the random number stream.
A set value is required to help reproduce the results.}

\item{verbose}{Logical scalar value: whether to print various estimates and statistics.}

\item{knots.coords}{Only relevant for GPP models fitted by either spTimer or spTDyn. 
Optional two column matrix of UTM-X and UTM-Y coordinates of the knots in kilometers.
It is preferable to specify the g_size parameter instead.}

\item{g_size}{Only relevant for GPP models fitted by either spTimer or spTDyn. 
The grid size c(m, n) for the knots for the GPP model. A square grid is assumed 
if this is passed on as a scalar. This does not need to be given if knots.coords is given instead.}
}
\value{
A list containing:
  \itemize{
   \item params - A table of parameter estimates 
   \item fit  -   The fitted model object. 
   \item datatostan - A list containing all the information sent to the 
   rstan package. 
   \item prior.phi.param  -    This contains the values of 
   the hyperparameters of the prior distribution for the spatial 
   decay parameter \eqn{phi}.   
   \item prior.phi  -    This contains the name of  of the prior 
   distribution for the spatial decay parameter \eqn{phi}.  
   \item validationplots - Present only if validation has been performed. 
   Contains three validation plots with or without segment and 
   an ordinary plot.  See \code{\link{obs_v_pred_plot}} for more. 
   \item fitteds  -   A vector of fitted values.   
   \item residuals   -   A vector of residual values.  
   \item package   -   The name of the package used for model fitting.  
   This is  always stan for this function. 
   \item model   -   The name of the fitted model.   
   \item call  -   The command used to call the model fitting function.  
   \item formula   -   The input formula for the regression part of 
   the model.  
   \item scale.transform  -   The transformation adopted by the 
    input argument with the same name.  
   \item sn   -   The number of data locations used in fitting.  
   \item tn   -   The number of time points used in fitting for each location.  
   \item computation.time  -   Computation time required 
   to run the model fitting.     
}
}
\description{
Model fitting and validation for spatio-temporal data from moving sensors in time.
}
\examples{
\donttest{
deep <- argo_floats_atlantic_2003[argo_floats_atlantic_2003$depth==3, ]
deep$x2inter <- deep$xinter*deep$xinter
deep$month <- factor(deep$month)
deep$lat2 <- (deep$lat)^2
deep$sin1 <- round(sin(deep$time*2*pi/365), 4)
deep$cos1 <- round(cos(deep$time*2*pi/365), 4)
deep$sin2 <- round(sin(deep$time*4*pi/365), 4)
deep$cos2 <- round(cos(deep$time*4*pi/365), 4)
deep[, c( "xlat2", "xsin1", "xcos1", "xsin2", "xcos2")] <- 
scale(deep[,c("lat2", "sin1", "cos1", "sin2", "cos2")])
f2 <- temp ~ xlon + xlat + xlat2+ xinter + x2inter 
M2 <- Bmoving_sptime(formula=f2, data = deep, coordtype="lonlat", 
coords = 1:2, N=11, burn.in=6, validrows =NULL, mchoice = FALSE)
summary(M2)
plot(M2)
names(M2)
}
}
\seealso{
\code{\link{Bsptime}} for spatio-temporal  model fitting.
}
