% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_misc.R
\name{roc.stat}
\alias{roc.stat}
\title{Compute statistics for ROC curve plotting}
\usage{
roc.stat(f, y)
}
\arguments{
\item{f}{decision value for each instance}

\item{y}{a logical that specify binary labels}
}
\value{
a data.frame() that compute for each threshold value 'f' roc curve statistics: TP, FP, TN, FN, FPR, TPR, sensitivity, specificity, precision, recall, accuracy
}
\description{
Compute statistics for ROC curve plotting
}
\examples{
  x <- cbind(data.matrix(iris[1:4]))
  w <- nrbmL1(rocLoss(x,iris$Species=="versicolor"),LAMBDA=0.01)
  with(roc.stat(x \%*\% w,iris$Species=="versicolor"),plot(FPR,TPR,type="l"))
  with(roc.stat(-x[,2],iris$Species=="versicolor"),lines(FPR,TPR,col="blue"))
}
\author{
Julien Prados, adapted from Bob Horton code
}
