% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loss_convex.R
\name{binaryClassificationLoss}
\alias{binaryClassificationLoss}
\alias{hingeLoss}
\alias{logisticLoss}
\alias{rocLoss}
\alias{fbetaLoss}
\title{Loss functions for binary classification}
\usage{
hingeLoss(x, y, loss.weights = 1)

logisticLoss(x, y, loss.weights = 1)

rocLoss(x, y)

fbetaLoss(x, y, beta = 1)
}
\arguments{
\item{x}{matrix of training instances (one instance by row)}

\item{y}{a logical vector representing the training labels for each instance in x}

\item{loss.weights}{numeric vector of loss weights to incure for each instance of x. 
Vector length should match length(y), but values are cycled if not of identical size.}

\item{beta}{a numeric value setting the beta parameter is the f-beta score}
}
\value{
a function taking one argument w and computing the loss value and the gradient at point w
}
\description{
Loss functions for binary classification
}
\section{Functions}{
\itemize{
\item \code{hingeLoss}: Hinge Loss for Linear Support Vector Machine (SVM)

\item \code{logisticLoss}: logistic regression

\item \code{rocLoss}: Find linear weights maximize area under its ROC curve

\item \code{fbetaLoss}: F-beta score loss function
}}

\examples{
  x <- cbind(intercept=100,data.matrix(iris[1:2]))
  w <- nrbm(hingeLoss(x,iris$Species=="setosa"));predict(w,x)
  w <- nrbm(logisticLoss(x,iris$Species=="setosa"));predict(w,x)
  w <- nrbm(rocLoss(x,iris$Species=="setosa"));predict(w,x)
  w <- nrbm(fbetaLoss(x,iris$Species=="setosa"));predict(w,x)
}
\references{
Teo et al.
  A Scalable Modular Convex Solver for Regularized Risk Minimization.
  KDD 2007
}
\seealso{
nrbm
}
