% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlm.R
\name{mlm}
\alias{mlm}
\title{Estimate a multilevel mediation model}
\usage{
mlm(d = NULL, id = "id", x = "x", m = "m", y = "y",
  slope_scale = NULL, tau_scale = NULL, intercept_scale = NULL,
  binary_y = FALSE, ...)
}
\arguments{
\item{d}{A \code{data.frame} or a \code{data_frame}.}

\item{id}{Column of participant IDs in \code{data}.}

\item{x}{Column of X values in \code{data}.}

\item{m}{Column of M values in \code{data}.}

\item{y}{Column of Y values in \code{data}.}

\item{slope_scale}{Prior standard deviation on regression slope coefficients.
See details.}

\item{tau_scale}{Prior scale on varying effects' SDs. See details.}

\item{intercept_scale}{Prior SD on regression intercept coefficients.}

\item{binary_y}{Set to TRUE if y is binary and should be modelled
with logistic regression. Defaults to FALSE (y treated as continuous.)}

\item{...}{Other optional parameters passed to \code{rstan::stan()}.}
}
\value{
An object of S4 class stanfit, with all its available methods.
}
\description{
Estimates a Bayesian multilevel mediation model using Stan.
}
\details{
Draw samples from the joint posterior distribution of a
multilevel mediation model using Stan.

\subsection{Priors}{

\code{slope_scale} Allows the user to input a standard deviation parameter
to the prior distributions for the slope parameters in a, b, and cp
paths. The default is 100, which is only very weakly informative for standardized
data, but users are recommended to adjust this to fit the scale of the data.
\code{intercept_scale} The same as above, but for the regression intercepts.
Defaults to 10.
\code{tau_scale} Allows the user to input a scale parameter to Cauchy
distributions on the varying effects' standard deviation parameters. The
default is 10, which is very weakly regularizing for standardized variables.

}
}
\examples{
\dontrun{
## Run example from Bolger and Laurenceau (2013)
data(BLch9)
fit <- mlm(BLch9)
mlm_summary(fit)
}

}
\author{
Matti Vuorre \email{mv2521@columbia.edu}
}

