% Generated by roxygen2 (4.0.0): do not edit by hand
\name{aggregateGradients}
\alias{aggregateGradients}
\title{Aggregate constraint gradients.}
\usage{
aggregateGradients(...)
}
\arguments{
\item{...}{gradients of constraint functions.}
}
\value{
a function which takes a value \code{X} and returns a matrix with
with dimensions \code{c(length(X), length(...))}. The (i,j) entry
of the return value is the i-th partial derivative of the j-th constraint,
evaluated at \code{X}.
}
\description{
Collect gradients of constraint functions into a matrix.
}
\examples{
Dg1 <- function(X){
  4 * X^3
}

Dg2 <- function(X){
  2 * X
}

DG <- aggregateGradients(Dg1, Dg2)
DG(c(1,1,1))
}
\seealso{
Other aggregate functions: \code{\link{aggregateConstraints}};
  \code{\link{aggregateHessians}}
}

