% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hugo.R
\name{bundle_site}
\alias{bundle_site}
\title{Convert post files to leaf bundles}
\usage{
bundle_site(dir = site_root(), output)
}
\arguments{
\item{dir}{The root directory of the website project (should contain a
\file{content/} folder).}

\item{output}{The output directory. If not provided, a suffix \file{-bundle}
is added to the website root directory name. For example, the default
output directory for the site under \file{~/Documents/test} is
\file{~/Documents/test-bundle}. You can specify the output directory to be
identical to the website root directory, so files will be moved within the
same directory, but please remember that you will not be able to undo
\code{bundle_site()}. You should modify the website in place \emph{only if
you have a backup for this directory or it is under version control}.}
}
\description{
For a post with the path \file{content/path/to/my-post.md}, it will be moved
to \file{content/path/to/my-post/index.md}, so it becomes the index file of a
leaf bundle of Hugo. This also applies to files with extensions \file{.Rmd}
and \file{.Rmarkdown}.
}
\note{
This function only moves (R) Markdown source files. If these files use
  resource files under the \file{static/} folder, these resources will not be
  moved into the \file{content/} folder. You need to manually move them, and
  adjust their paths in the (R) Markdown source files accordingly.
}
\examples{
\dontrun{
blogdown::bundle_site(".", "../new-site/")
blogdown::bundle_site(".", ".")  # move files within the current working directory
}
}
\references{
Learn more about Hugo's leaf bundles at
  \url{https://gohugo.io/content-management/page-bundles/}.
}
