% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.pwsd.R
\name{plot.pwsd}
\alias{plot.pwsd}
\title{Plot Correlogram for Politis and White Auto\eqn{-}Correlation Implied Hypothesis Test}
\usage{
\method{plot}{pwsd}(x, c = NULL, ...)
}
\arguments{
\item{x}{an of object of class 'pwsd' or 'acf'}

\item{c}{a numeric value, the constant which acts as the significance level
for the implied hypothesis test. Defaults to \code{qnorm(0.975)} for a 95\%
confidence level. Politis and  White (2004) suggest \code{c = 2}.}

\item{...}{
  Arguments passed on to \code{\link[base:plot]{base::plot}}
  \describe{
    \item{\code{y}}{the y coordinates of points in the plot, \emph{optional}
    if \code{x} is an appropriate structure.}
  }}
}
\value{
No return value, called for side effects
}
\description{
S3 Method for objects of class 'pwsd'
\emph{See} \code{?plot.acf} of the \pkg{stats} package for more customization
 options on the correlogram, from which \code{plot.pwsd} is based
}
\examples{
# Use S3 Method

# Generate AR(1) time series
sim <- stats::arima.sim(list(order = c(1, 0, 0), ar = 0.5),
                        n = 500, innov = rnorm(500))

b <- pwsd(sim, round = TRUE, correlogram = FALSE)
plot(b)

}
