% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coclusterBinary.R
\name{coclusterBinary}
\alias{coclusterBinary}
\title{Co-Clustering function for Binary data.}
\usage{
coclusterBinary(data, semisupervised = FALSE, rowlabels = numeric(0),
  collabels = numeric(0), model = character(0), nbcocluster,
  strategy = coclusterStrategy(), a = 1, b = 1)
}
\arguments{
\item{data}{Input data as matrix (or list containing data matrix)}

\item{semisupervised}{Boolean value specifying whether to perform
semi-supervised co-clustering or not. Make sure to provide row and/or
column labels if specified value is true. The default value is false.}

\item{rowlabels}{Vector specifying the class of rows.
The class number starts from zero. Provide -1 for unknown row class.}

\item{collabels}{Vector specifying the class of columns.
The class number starts from zero. Provide -1 for unknown column class.}

\item{model}{This is the name of model. The following models exists for
Binary data:
\tabular{rlll}{
    Model  \tab Data-type \tab Proportions \tab Dispersion/Variance \cr
    pik_rhol_epsilonkl(Default) \tab binary \tab unequal \tab unequal \cr
    pik_rhol_epsilon \tab binary \tab unequal \tab equal \cr
    pi_rho_epsilonkl \tab binary \tab equal \tab unequal \cr
    pi_rho_epsilon \tab binary \tab equal \tab equal \cr
}}

\item{nbcocluster}{Integer vector specifying the number of row and column clusters respectively.}

\item{strategy}{Object of class \code{\linkS4class{strategy}}.}

\item{a}{First hyper-parameter in case of Bayesian settings. Default is 1 (no prior).}

\item{b}{Second hyper-parameter in case of Bayesian settings. Default is 1 (no prior).}
}
\value{
Return an object of \code{\linkS4class{BinaryOptions}}.
}
\description{
This function performs Co-Clustering (simultaneous clustering of rows and
columns ) for Binary data-sets using latent block models.
It can also be used to perform semi-supervised co-clustering.
}
\examples{

## Simple example with simulated binary data
## load data
data(binarydata)
## usage of coclusterBinary function in its most simplest form
out<-coclusterBinary(binarydata,nbcocluster=c(2,3))
## Summarize the output results
summary(out)
## Plot the original and Co-clustered data 
plot(out)


}

