% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yaff.R
\name{read_yaff}
\alias{read_yaff}
\alias{write_yaff}
\title{Read and write yaff bitmap font files}
\usage{
read_yaff(con)

write_yaff(font, con = stdout())
}
\arguments{
\item{con}{A connection object or a character string of a filename.
See \code{\link[base:readLines]{base::readLines()}} or \code{\link[base:writeLines]{base::writeLines()}} for more info.
If it is a connection it will be explicitly closed.}

\item{font}{A \code{\link[=bm_font]{bm_font()}} object.}
}
\value{
\code{read_yaff()} returns a \code{\link[=bm_font]{bm_font()}} object.
\code{write_yaff()} returns invisibly a character vector of the contents
of the yaff font file it wrote to \code{con} as a side effect.
}
\description{
\code{read_yaff()} reads in yaff format bitmap font files
as a \code{\link[=bm_font]{bm_font()}} object while \code{write_yaff()} writes a \code{\link[=bm_font]{bm_font()}} object
as a yaff format bitmap font file.
}
\examples{
 font_file <- system.file("fonts/fixed/4x6.yaff.gz", package = "bittermelon")
 font <- read_yaff(font_file)
 capital_r <- font[[str2ucp("R")]]
 print(capital_r, px = c(".", "#"))

 filename <- tempfile(fileext = ".yaff")
 write_yaff(font, filename)
}
\seealso{
\code{\link[=bm_font]{bm_font()}} for information about bitmap font objects.
For more information about yaff font format see \url{https://github.com/robhagemans/monobit#the-yaff-format}.
}
