% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_padding_lengths.R
\name{bm_padding_lengths}
\alias{bm_padding_lengths}
\title{Compute bitmap padding lengths}
\usage{
bm_padding_lengths(bm_object, value = 0L)
}
\arguments{
\item{bm_object}{Either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_list]{bm_list()}},  or \code{\link[=bm_font]{bm_font()}} object.}

\item{value}{The value of the \dQuote{padding} integer to compute lengths for.}
}
\value{
If \code{bm_object} is a \code{bm_bitmap()} object then a integer vector of length four
representing the padding lengths for the top, right, bottom, and left sides respectively.
If \code{bm_object} is a \code{bm_list()} or \code{bm_font()} then a list of integer vectors of length four.
}
\description{
\code{bm_padding_lengths()} computes the padding lengths of a
target value for the top, right, bottom, and left sides of the bitmap.
If the entire bitmap is of the target value then the left/right and top/bottom
will simply split the width/height in half.
}
\examples{
 font_file <- system.file("fonts/spleen/spleen-8x16.hex.gz", package = "bittermelon")
 font <- read_hex(font_file)
 # add a border to an "R"
 capital_r <- font[[str2ucp("R")]]
 print(capital_r, px = c(".", "@"))
 print(bm_padding_lengths(capital_r))
}
