% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/birp_data.R
\name{plot.birp_data}
\alias{plot.birp_data}
\title{Plotting a birp_data Object}
\usage{
\method{plot}{birp_data}(
  x,
  col = 1:length(x$locations),
  lwd = 1,
  lty = 1:length(x$method_names),
  pch = 1:length(x$CI_groups),
  xlab = "time",
  ylab = "counts per unit of effort",
  legend.x = "topright",
  legend.y = NULL,
  legend.bty = "o",
  xlim = range(as.numeric(x$times)),
  ylim = NA,
  ...
)
}
\arguments{
\item{x}{The birp data object to be printed.}

\item{col}{A vector of colors, recycled to match the number of methods and locations}

\item{lwd}{A vector of line width, recycled to match the number of methods and locations}

\item{lty}{A vector of line types, recycled to match the number of methods and locations}

\item{pch}{A vector of plotting characters, recycled to match the number of control/intervention groups}

\item{xlab}{The label of the x-axis}

\item{ylab}{The label of the y-axis}

\item{legend.x}{The x coordinate to position the legend. Use legend.x=NA to omit legend}

\item{legend.y}{The y coordinate to position the legend}

\item{legend.bty}{The type of box to be drawn around the legend. The allowed values are "o" (the default) and "n".}

\item{xlim}{Set the limits of the x-axis}

\item{ylim}{Set the limits of the y-axis}

\item{...}{Additional parameters passed to plotting functions.}
}
\value{
No return value, called for side effects
}
\description{
This function plots the counts per unit of effort per time-point, method and location
}
\examples{
data <- simulate_birp()
plot(data)
}
