\name{biotools-package}
\alias{biotools-package}
\alias{biotools}
\docType{package}

\title{ Tools for Biometry and Applied Statistics in Agricultural Science }

\description{
Tools designed to perform and work with cluster analysis (including Tocher's algorithm), 
discriminant analysis and path analysis (standard and under collinearity), as well as some 
useful miscellaneous tools for dealing with sample size and optimum plot size calculations.
Mantel's permutation test can be found in this package. A new approach for calculating its
power is implemented. biotools also contains the new tests for genetic covariance components.
An approach for predicting spatial gene diversity is implemented.
}

\details{
\tabular{ll}{
Package: \tab biotools\cr
Type: \tab Package\cr
Version: \tab 3.1\cr
Date: \tab 2017-05-25\cr
License: \tab GPL (>= 2)\cr
}
}

\note{
\emph{biotools} is an ongoing project.
Any and all criticism, comments and suggestions are welcomed.
}

\author{
Anderson Rodrigo da Silva

Maintainer: Anderson Rodrigo da Silva <anderson.agro@hotmail.com>
}

\references{
Carvalho, S.P. (1995) \emph{Metodos alternativos de estimacao de coeficientes de
   trilha e indices de selecao, sob multicolinearidade}. Ph.D. Thesis, 
   Federal University of Vicosa (UFV), Vicosa, MG, Brazil.

Cruz, C.D.; Ferreira, F.M.; Pessoni, L.A. (2011) \emph{Biometria aplicada ao estudo
   da diversidade genetica}. Visconde do Rio Branco: Suprema.

Lessman, K. J. & Atkins, R. E. (1963). Optimum plot size and relative
   efficiency of lattice designs for grain sorghum yield tests.
   \emph{Crop Sci}., 3:477-481.

Mahalanobis, P. C. (1936) On the generalized distance in statistics.
   \emph{Proceedings of The National Institute of Sciences of India}, 12:49-55.

Manly, B.F.J. (2004) \emph{Multivariate statistical methods}: a primer. CRC Press.

Meier, V. D. & Lessman, K. J. (1971) Estimation of optimum field plot
   shape and size for testing yield in Crambe abyssinia Hochst.
   \emph{Crop Sci}., 11:648-650.

Morrison, D.F. (1976) \emph{Multivariate Statistical Methods}.

Rao, R.C. \emph{Advanced statistical methods in biometric research}. New York:
   John Wiley & Sons, 1952.

Sharma, J.R. (2006) \emph{Statistical and biometrical techniques in plant breeding}.
   Delhi: New Age International.

da Silva, A.R.; Malafaia, G.; Menezes, I.P.P. (2017) biotools: an R function to predict 
   spatial gene diversity via an individual-based approach. \emph{Genetics and Molecular Research}, 
   16: gmr16029655. 

Silva, A.R. & Dias, C.T.S. (2013) A cophenetic correlation coefficient for
   Tocher's method. \emph{Pesquisa Agropecuaria Brasileira}, 48:589-596.

Silva et al. (2013) Path analysis in multicollinearity for fruit traits of pepper.
   \emph{Idesia}, 31:55-60.

Singh, D. (1981) The relative importance of characters affecting genetic
   divergence. \emph{Indian Journal Genetics & Plant Breeding}, 41:237-245.

}

\keyword{ package }
