% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks_validation.R
\name{validate_seq}
\alias{validate_seq}
\title{Sequence validator}
\usage{
validate_seq(x, alphabet, invalid_replacement, type = "DNA")
}
\arguments{
\item{x}{a character vector.}

\item{alphabet}{a character vector defining the sequence alphabet;}

\item{invalid_replacement}{a character to replace non valid characters}

\item{type}{type of sequence ("DNA", "RNA", "AA"). It is only
used to provide more informative warning messages.}
}
\value{
A character vector.
}
\description{
Validate character strings before sequence construction.
}
\details{
Validation steps:
\enumerate{
  \item Check that \code{x} is a character vector, fails if not.
  \item Force alpha characters to uppercase
  \item Delete blank characters (spaces and tabs)
  \item Delete line breaks
  \item Converts . (dots) to - (as both can represent a gap)
  \item Replace invalid characters with N/X (with a warning).
}
}
\keyword{internal}
