
# bioseq: A Toolbox for Manipulating Biological Sequences in R
<img src="man/figures/logo.png" align="right" width="150"/>

<!-- badges: start -->
[![R build status](https://github.com/fkeck/bioseq/workflows/R-CMD-check/badge.svg)](https://github.com/fkeck/bioseq/actions)
[![Codecov test coverage](https://codecov.io/gh/fkeck/bioseq/branch/master/graph/badge.svg)](https://codecov.io/gh/fkeck/bioseq?branch=master)
[![CRAN status](https://www.r-pkg.org/badges/version/bioseq)](https://www.r-pkg.org/badges/version/bioseq)
<!-- badges: end -->

The purpose of `bioseq` is to provide a collection of classes and functions for biological sequence manipulation in R. The package provides simple S3 classes for sequences that are suitable for inclusion in a data frame and that can be analysed using the `dplyr` grammar and other `tidyverse` tools.

## Installation

You can install the development version of `bioseq` from GitHub with:

``` r
remotes::install_github("fkeck/bioseq")
```

## Tutorials

There are two vignettes available to get started with the package:

- Introduction to the `bioseq` package
- Cleaning and exploring NCBI data with the `bioseq` package


## Citation

If you use bioseq please cite Keck F. (2020) Handling biological sequences in R with the bioseq package. Methods in Ecology and Evolution. [doi:10.1111/2041-210X.13490](https://besjournals.onlinelibrary.wiley.com/doi/abs/10.1111/2041-210X.13490)
