% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomod2_classes_3.R
\name{getters.out}
\alias{getters.out}
\alias{get_options}
\alias{get_calib_lines}
\alias{get_formal_data}
\alias{get_projected_models}
\alias{free}
\alias{get_predictions}
\alias{get_needed_models}
\alias{get_kept_models}
\alias{get_built_models}
\alias{get_evaluations}
\alias{get_variables_importance}
\alias{get_options,BIOMOD.models.out-method}
\alias{get_calib_lines,BIOMOD.models.out-method}
\alias{get_formal_data,BIOMOD.models.out-method}
\alias{get_predictions,BIOMOD.models.out-method}
\alias{get_built_models,BIOMOD.models.out-method}
\alias{get_evaluations,BIOMOD.models.out-method}
\alias{get_variables_importance,BIOMOD.models.out-method}
\alias{get_projected_models,BIOMOD.projection.out-method}
\alias{free,BIOMOD.projection.out-method}
\alias{get_predictions,BIOMOD.projection.out-method}
\alias{get_formal_data,BIOMOD.ensemble.models.out-method}
\alias{get_built_models,BIOMOD.ensemble.models.out-method}
\alias{get_needed_models,BIOMOD.ensemble.models.out-method}
\alias{get_kept_models,BIOMOD.ensemble.models.out-method}
\alias{get_predictions,BIOMOD.ensemble.models.out-method}
\alias{get_evaluations,BIOMOD.ensemble.models.out-method}
\alias{get_variables_importance,BIOMOD.ensemble.models.out-method}
\title{Functions to extract informations from \code{\link{BIOMOD.models.out}}, 
\code{\link{BIOMOD.projection.out}} or \code{\link{BIOMOD.ensemble.models.out}} objects}
\usage{
\S4method{get_options}{BIOMOD.models.out}(obj)

\S4method{get_calib_lines}{BIOMOD.models.out}(obj, as.data.frame = FALSE, ...)

\S4method{get_formal_data}{BIOMOD.models.out}(obj, subinfo = NULL)

\S4method{get_predictions}{BIOMOD.models.out}(
  obj,
  as.data.frame = FALSE,
  evaluation = FALSE,
  full.name = NULL,
  model = NULL,
  run.eval = NULL,
  data.set = NULL
)

\S4method{get_built_models}{BIOMOD.models.out}(obj, ...)

\S4method{get_evaluations}{BIOMOD.models.out}(obj, as.data.frame = FALSE, ...)

\S4method{get_variables_importance}{BIOMOD.models.out}(obj, as.data.frame = FALSE, ...)

\S4method{get_projected_models}{BIOMOD.projection.out}(obj)

\S4method{free}{BIOMOD.projection.out}(obj)

\S4method{get_predictions}{BIOMOD.projection.out}(
  obj,
  as.data.frame = FALSE,
  full.name = NULL,
  model = NULL,
  run.eval = NULL,
  data.set = NULL
)

\S4method{get_formal_data}{BIOMOD.ensemble.models.out}(obj, subinfo = NULL)

\S4method{get_built_models}{BIOMOD.ensemble.models.out}(obj, ...)

\S4method{get_needed_models}{BIOMOD.ensemble.models.out}(obj, selected.models = "all", ...)

\S4method{get_kept_models}{BIOMOD.ensemble.models.out}(obj, model, ...)

\S4method{get_predictions}{BIOMOD.ensemble.models.out}(
  obj,
  as.data.frame = FALSE,
  evaluation = FALSE,
  full.name = NULL
)

\S4method{get_built_models}{BIOMOD.ensemble.models.out}(obj, ...)

\S4method{get_evaluations}{BIOMOD.ensemble.models.out}(obj, as.data.frame = FALSE, ...)

\S4method{get_variables_importance}{BIOMOD.ensemble.models.out}(obj, as.data.frame = FALSE, ...)
}
\arguments{
\item{obj}{a \code{\link{BIOMOD.models.out}}, \code{\link{BIOMOD.projection.out}} or 
\code{\link{BIOMOD.ensemble.models.out}} object}

\item{as.data.frame}{a \code{logical} defining whether output should be returned as 
\code{data.frame} or \code{array} object}

\item{subinfo}{a \code{character} corresponding to the information to be extracted, must be 
among \code{NULL}, \code{expl.var.names}, \code{resp.var}, \code{expl.var}, \code{MinMax}, 
\code{eval.resp.var}, \code{eval.expl.var} (see Details)}

\item{evaluation}{a \code{logical} defining whether evaluation data should be used or not}

\item{full.name}{a \code{vector} containing model names to be kept, must be either \code{all} 
or a sub-selection of model names}

\item{model}{a \code{character} corresponding to the model name, must be either \code{GLM}, 
\code{GBM}, \code{GAM}, \code{CTA}, \code{ANN}, \code{SRE}, \code{FDA}, \code{MARS}, 
\code{RF}, \code{MAXENT.Phillips}, \code{MAXENT.Phillips.2}}

\item{run.eval}{a \code{vector} containing repetition set to be loaded, must be among 
\code{RUN1}, \code{RUN2}, \code{...}, \code{Full}}

\item{data.set}{a \code{vector} containing pseudo-absence set to be loaded, must be among 
\code{PA1}, \code{PA2}, \code{...}}

\item{selected.models}{a \code{vector} containing names of the needed models of a 
\code{\link{BIOMOD.ensemble.models.out}} object}

\item{\ldots}{(\emph{optional, one or several of the following arguments depending on the selected 
function)})}
}
\value{
\describe{
  \item{\code{get_options}}{a
  \code{\link{BIOMOD.stored.models.options-class}} object from the
  \code{models.options} slot of a \code{\link{BIOMOD.models.out-class}}
  object} \item{\code{get_calib_lines}}{a
  \code{\link{BIOMOD.stored.array-class}} object from the \code{calib.lines}
  slot of a \code{\link{BIOMOD.models.out}} object}

  \item{\code{get_projected_models}}{a \code{vector} from the
  \code{models.projected} slot of a \code{\link{BIOMOD.projection.out}}
  object}

  \item{\code{get_predictions}}{a \code{\link{BIOMOD.stored.data}} object
  from the \code{proj.out} slot of a \code{\link{BIOMOD.models.out}},
  \code{\link{BIOMOD.projection.out}} or
  \code{\link{BIOMOD.ensemble.models.out}} object}

  \item{\code{get_needed_models}}{a \code{vector} containing names of the
  needed models of a \code{\link{BIOMOD.ensemble.models.out}} object}
  \item{\code{get_kept_models}}{a \code{vector} containing names of the kept
  models of a \code{\link{BIOMOD.ensemble.models.out}} object}

  \item{\code{get_formal_data}}{depending on the \code{subinfo} parameter :
  \describe{
    \item{\code{NULL}}{a \code{\link{BIOMOD.stored.formated.data-class}} (or
    \code{\link{BIOMOD.stored.models.out-class}}) object from the
    \code{formated.input.data} (or \code{models.out}) slot of a
    \code{\link{BIOMOD.models.out}} (or
    \code{\link{BIOMOD.ensemble.models.out}}) object}
    
    \item{\code{expl.var.names}}{a \code{vector} from the
    \code{expl.var.names} slot of a \code{\link{BIOMOD.models.out}} or
    \code{\link{BIOMOD.ensemble.models.out}} object}
    \item{\code{resp.var}}{a \code{vector} from the \code{data.species} slot
    of the \code{formated.input.data} slot of a
    \code{\link{BIOMOD.models.out}} or
    \code{\link{BIOMOD.ensemble.models.out}} object}
    
    \item{\code{expl.var}}{a \code{data.frame} from the \code{data.env.var}
    slot of the \code{formated.input.data} slot of a
    \code{\link{BIOMOD.models.out}} or
    \code{\link{BIOMOD.ensemble.models.out}} object}
    
    \item{\code{MinMax}}{a \code{list} of minimum and maximum values (or
    levels if factorial) of variable contained in the \code{data.env.var}
    slot of the \code{formated.input.data} slot of a
    \code{\link{BIOMOD.models.out}} or
    \code{\link{BIOMOD.ensemble.models.out}} object}
    
    \item{\code{eval.resp.var}}{a \code{vector} from the
    \code{eval.data.species} slot of the \code{formated.input.data} slot of
    a \code{\link{BIOMOD.models.out}} or
    \code{\link{BIOMOD.ensemble.models.out}} object}
    
    \item{\code{eval.expl.var}}{a \code{data.frame} from the
    \code{eval.data.env.var} slot of the \code{formated.input.data} slot of
    a \code{\link{BIOMOD.models.out}} or
    \code{\link{BIOMOD.ensemble.models.out}} object}
  }
  }
  \item{\code{get_built_models}}{a \code{vector} from the
  \code{models.computed} slot (or \code{em.computed}) of a
  \code{\link{BIOMOD.models.out}} (or
  \code{\link{BIOMOD.ensemble.models.out}}) object}
  \item{\code{get_evaluations}}{a
  \code{\link{BIOMOD.stored.array-class}} (or
  \code{matrix}) from the \code{models.evaluation} slot (or
  \code{model_evaluation} of each model in \code{em.computed}) of a
  \code{\link{BIOMOD.models.out}} (or
  \code{\link{BIOMOD.ensemble.models.out}}) object}
  \item{\code{get_variables_importance}}{a
  \code{\link{BIOMOD.stored.array-class}} from
  the \code{variables.importance} slot (or \code{model_variables_importance}
  of each model in \code{em.models}) of a \code{\link{BIOMOD.models.out}}
  (or \code{\link{BIOMOD.ensemble.models.out}}) object}
}
}
\description{
These functions allow the user to easily retrieve informations stored in the 
different \pkg{biomod2} objects from the different modeling steps, such as modeling options 
and formated data, models used or not, predictions, evaluations, variables importance.
}
\seealso{
\code{\link{BIOMOD.models.out}}, \code{\link{BIOMOD.projection.out}}, 
\code{\link{BIOMOD.ensemble.models.out}}

Other Toolbox functions: 
\code{\link{getters.bm}},
\code{\link{load_stored_object}()},
\code{\link{predict.bm}},
\code{\link{predict.em}},
\code{\link{predict2.bm}},
\code{\link{predict2.em}}
}
\author{
Damien Georges
}
\concept{Toolbox functions}
