% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_multi_dynamic.R
\name{fit_multiple_growth}
\alias{fit_multiple_growth}
\title{Fitting growth models to multiple dynamic experiments}
\usage{
fit_multiple_growth(
  starting_point,
  experiment_data,
  known_pars,
  sec_model_names,
  ...,
  check = TRUE,
  formula = logN ~ time,
  logbase_mu = logbase_logN,
  logbase_logN = 10
)
}
\arguments{
\item{starting_point}{a named vector of starting values for the model parameters.}

\item{experiment_data}{a nested list with the experimental data. Each entry describes
one experiment as a list with two elements: data and conditions. \code{data} is a tibble
with a column giving the elapsed time (named "time" by default) and another one
with the decimal logarithm of the population size (named "logN" by default).
\code{conditions} is a tibble with one column giving the elapsed time (using the
same name as \code{data}) and as many additional columns as environmental factors.
The default column names can be changed with the formula argument.}

\item{known_pars}{named vector of known model parameters}

\item{sec_model_names}{named character vector with names of the
environmental conditions and values of the secondary model (see secondary_model_data).}

\item{...}{additional arguments for \code{\link[FME:modFit]{FME::modFit()}}.}

\item{check}{Whether to check the validity of the models. \code{TRUE} by default.}

\item{formula}{an object of class "formula" describing the x and y variables.
\code{logN ~ time} as a default.}

\item{logbase_mu}{Base of the logarithm the growth rate is referred to.
By default, the same as logbase_logN. See vignette about units for details.}

\item{logbase_logN}{Base of the logarithm for the population size. By default,
10 (i.e. log10). See vignette about units for details.}
}
\value{
An instance of \code{\link[=FitMultipleDynamicGrowth]{FitMultipleDynamicGrowth()}}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

The function \code{\link[=fit_multiple_growth]{fit_multiple_growth()}} has been superseded by the top-level
function \code{\link[=fit_growth]{fit_growth()}}, which provides a unified approach for growth modelling.

But, if you so wish, this function still enables fitting a growth model using a dataset comprised of
several experiments with potentially different dynamic experimental conditions.
Note that the definition of secondary models must comply with the
\code{secondary_model_data} function.
}
\examples{
\donttest{
## We will use the multiple_experiments data set

data("multiple_experiments")

## For each environmental factor, we need to defined a model

sec_names <- c(temperature = "CPM", pH = "CPM")

## Any model parameter can be fixed

known <- list(Nmax = 1e8, N0 = 1e0, Q0 = 1e-3,
    temperature_n = 2, temperature_xmin = 20, temperature_xmax = 35,
    pH_n = 2, pH_xmin = 5.5, pH_xmax = 7.5, pH_xopt = 6.5)

## The rest require starting values for model fitting

start <- list(mu_opt = .8, temperature_xopt = 30)

## We can now call the fitting function

global_fit <- fit_multiple_growth(start, multiple_experiments, known, sec_names)

## Parameter estimates can be retrieved with summary

summary(global_fit)

## We can compare fitted model against observations

plot(global_fit)

## Any single environmental factor can be added to the plot using add_factor

plot(global_fit, add_factor = "temperature")
}

}
