% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_encoding.R
\name{create_encoding}
\alias{create_encoding}
\title{Create encoding}
\usage{
create_encoding(prop, len)
}
\arguments{
\item{prop}{\code{matrix} of properties with number of column equal to the 
length of the alphabet. Column must be named after elements of the 
alphabet. Each row represents a different physicochemical property.}

\item{len}{length of the resulting encoding. Must be larger than zero and 
smaller than number of elements in the alphabet.}
}
\value{
An encoding.
}
\description{
Reduces an alphabet using physicochemical properties.
}
\details{
The encoding is a list of groups to which elements of an alphabet 
should be reduced. All elements of the alphabet (all 
amino acids or all nucleotides) should appear in the encoding.
}
\examples{
enc1 = list(`1` = c("a", "t"), 
            `2` = c("g", "c"))
encoding2df(enc1)
}
\seealso{
\code{\link{calc_ed}}: calculate the encoding distance between two encodings.
\code{\link{encoding2df}}: converts an encoding to a data frame.
\code{\link{validate_encoding}}: validate a structure of an encoding.
}
\keyword{hclust}

