% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degenerate.R
\name{degenerate}
\alias{degenerate}
\title{Degenerate protein sequence}
\usage{
degenerate(seq, element_groups)
}
\arguments{
\item{seq}{\code{character} vector or matrix representing single sequence.}

\item{element_groups}{encoding of elements: list of groups to which elements 
of sequence should be aggregated. Must have unique names.}
}
\value{
A \code{character} vector or matrix (if input is a matrix) 
containing aggregated elements.
}
\description{
'Degenerates' amino acid or nucleic sequence by aggregating 
elements to bigger groups.
}
\note{
Characters not present in the \code{element_groups} will be converted to NA with a 
warning.
}
\examples{
sample_seq <- c(1, 3, 1, 3, 4, 4, 3, 1, 2)
table(sample_seq)

# aggregate sequence to purins and pyrimidines
deg_seq <- degenerate(sample_seq, list(w = c(1, 4), s = c(2, 3)))
table(deg_seq)
}
\seealso{
\code{\link{l2n}} to easily convert information stored in biological sequences from 
letters to numbers.
\code{\link{calc_ed}} to calculate distance between encodings.
}
\keyword{manip}

