% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dorfman.Functions.R
\name{characteristics.pool}
\alias{characteristics.pool}
\title{Testing expenditure for informative Dorfman testing}
\usage{
characteristics.pool(p, se, sp)
}
\arguments{
\item{p}{a vector of each individual's probability of infection.}

\item{se}{the sensitivity of the diagnostic test.}

\item{sp}{the specificity of the diagnostic test.}
}
\value{
a list containing:
\item{e}{the expected testing expenditure of the pool.}
\item{v}{the variation of the testing expenditure of the pool.}
}
\description{
Calculate the expectation and variation of the testing
expenditure of a pool used with informative Dorfman testing.
}
\details{
This function calculates the expected value and variance
of the testing expenditure of a pool of size greater than or equal 
to one used with informative Dorfman testing. Calculations of these 
measures are done using the equations presented in McMahan et al. (2012).
}
\examples{
# This example takes less than 1 second to run.
# Estimated running time was calculated using a 
#   computer with 16 GB of RAM and one core of an 
#   Intel i7-6500U processor.
set.seed(8135)
p.vec <- p.vec.func(p=0.02, alpha=1, grp.sz=10)
characteristics.pool(p=p.vec[1:3], se=0.90, sp=0.90)
}
\references{
\insertRef{McMahan2012a}{binGroup}
}
\seealso{
\url{http://chrisbilder.com/grouptesting}

Other Informative Dorfman functions: \code{\link{accuracy.dorf}},
  \code{\link{inf.dorf.measures}},
  \code{\link{opt.info.dorf}}, \code{\link{opt.pool.size}},
  \code{\link{pool.specific.dorf}},
  \code{\link{thresh.val.dorf}}
}
\author{
This function was originally written by Christopher S. 
McMahan for McMahan et al. (2012). The function was obtained 
from \url{http://chrisbilder.com/grouptesting}.
}
